<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title"><?php echo e(__($setTitle)); ?></h4>
                    </div>

                    <div class="row g-4">
                        <?php $__currentLoopData = $cryptoCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                                <div class="i-card1-sm card-style linear-bg rounded-3">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h5 class="title text--purple mb-0"><?php echo e($crypto->pair); ?></h5>
                                        <div class="avatar--sm bg--purple">
                                            <img src="<?php echo e($crypto->file); ?>" class="avatar--sm" alt="<?php echo e(__('Crypto-Image')); ?>">
                                        </div>
                                    </div>

                                    <div class="card-info text-center">
                                        <ul class="user-card-list w-100">
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold"><?php echo e(__('Price')); ?></span>
                                                <span class="fw-bold text--dark">$<?php echo e(getArrayValue($crypto->meta, 'current_price')); ?></span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold"><?php echo e(__('Market Cap')); ?></span>
                                                <span class="fw-bold text--dark"><?php echo e(getArrayValue($crypto->meta, 'market_cap')); ?></span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                                                <span class="fw-bold"><?php echo e(__('Daily High')); ?></span>
                                                <span class="fw-bold text--dark"><?php echo e(getArrayValue($crypto->meta, 'high_24h')); ?> %</span>
                                            </li>
                                            <li class="d-flex align-items-center justify-content-between gap-3">
                                                <span class="fw-bold"><?php echo e(__('Daily Low')); ?></span>
                                                <span class="fw-bold text--dark"><?php echo e(getArrayValue($crypto->meta, 'low_24h')); ?> %</span>
                                            </li>
                                        </ul>
                                        <?php if(getArrayValue($setting->system_configuration, 'binary_trade.value') == \App\Enums\Status::ACTIVE->value): ?>
                                            <a href="<?php echo e(route('user.trade.binary', $crypto->crypto_id)); ?>" class="i-btn btn--sm btn--primary-outline capsuled"><?php echo e(__('Trade')); ?></a>
                                        <?php endif; ?>
                                        <?php if(getArrayValue($setting->system_configuration, 'practice_trade.value') == \App\Enums\Status::ACTIVE->value): ?>
                                            <a href="<?php echo e(route('user.trade.practice', $crypto->crypto_id)); ?>" class="i-btn btn--sm btn--lite--secondary capsuled"><?php echo e(__('Practice')); ?></a>
                                        <?php endif; ?>
                                        <?php if(getArrayValue($setting->system_configuration, 'binary_trade.value') != \App\Enums\Status::ACTIVE->value && getArrayValue($setting->system_configuration, 'practice_trade.value') != \App\Enums\Status::ACTIVE->value): ?>
                                            <span><?php echo e(__('N/A')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <div class="mt-4"><?php echo e($cryptoCurrency->links()); ?></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>











<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/trade/index.blade.php ENDPATH**/ ?>