<?php

namespace App\Jobs;

use App\Models\User;
use App\Services\SettingService;
use App\Models\Setting;
use App\Models\SmsGateway;
use App\Sms\MessageBird;
use App\Sms\TextMagic;
use App\Sms\TwilioSms;
use App\Sms\FastSms;
use App\Enums\SMS\SmsGatewayName;
use ErrorException;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendSmsVerificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(protected User $user, protected array $replacer, protected string $otp, protected string $code){
        $this->onConnection('database');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
		$setting = SettingService::getSetting();
		//dd($setting);
        $mailContent = mail_content($this->code);
		$this->sendSms($mailContent, $setting);
    }
	protected function sendSms(array $mailContent, Setting $setting): void
    {
		//dd($setting);
        $smsGateway = SmsGateway::where('id', $setting->sms_gateway_id)->first();

        if(!$smsGateway){
            return ;
        }

        $gateway = match ($smsGateway->code) {
            'TWILIO102' => new TwilioSms(),
            'IMESSAGE103' => new MessageBird(),
            'MAGIC104' => new TextMagic(),
            'FAST2SMS105' => new FastSms(),
            default => throw new Exception("Unknown SMS gateway code: {$smsGateway->code}"),
        };

        if ($this->user->phone) {
			if ($smsGateway->code == SmsGatewayName::FAST->value) {
				$gateway->verification(
					$smsGateway->credential,
					$this->user->phone,
					$this->otp
				);
			}else{
				$gateway->send(
					$smsGateway->credential,
					$this->user->phone,
					text_replacer(getArrayValue($mailContent,'sms_content'),$this->replacer)
				);
			}
        }
    }
}
