<?php $__env->startSection('panel'); ?>
    <section>
        <div class="container-fluid p-0">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__($setTitle)); ?></h4>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(route('admin.competition.update', $competition->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-wrapper">
                            <div class="row g-3">
								<div class="mb-3 col-lg-6 col-md-12">
                                    <label for="title" class="form-label"> <?php echo app('translator')->get('Title'); ?> <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control" name="title" id="title" value="<?php echo e($competition->title); ?>" placeholder="<?php echo app('translator')->get('Enter Title'); ?>" required>
                                </div>

								<div class="mb-3 col-lg-3 col-md-12">
                                    <label for="competition_start" class="form-label"> <?php echo app('translator')->get('Competition Started At'); ?> <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control datepicker-here" name="competition_start" id="competition_start" value="<?php echo e(showDateTime($competition->start_time, 'm/d/Y h:i a')); ?>" placeholder="<?php echo app('translator')->get('Competition Started At'); ?>" 
                                   data-language="en" data-position="bottom right" data-timepicker="1" autocomplete="off" required>
                                </div>

								<div class="mb-3 col-lg-3 col-md-12">
                                    <label for="competition_end" class="form-label"> <?php echo app('translator')->get('Competition Ends At'); ?> <sup class="text-danger">*</sup></label>
                                    <input type="text" class="form-control datepicker-here" name="competition_end" id="competition_end" value="<?php echo e(showDateTime($competition->end_time, 'm/d/Y h:i a')); ?>" placeholder="<?php echo app('translator')->get('Competition Ends At'); ?>" 
                                   data-language="en" data-position="bottom right" data-timepicker="1" autocomplete="off" required>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="prize_pool_amt" class="form-label"> <?php echo app('translator')->get('Prize Pool'); ?> <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="prize_pool_amt" name="prize_pool_amt" step="any" placeholder="Enter Prize Pool Amount" value="<?php echo e($competition->prize_pool_amt); ?>" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="entry_fee" class="form-label"> <?php echo app('translator')->get('Entry Fee'); ?> <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="entry_fee" name="entry_fee" step="any" placeholder="Enter Entry Fee" value="<?php echo e($competition->entry_fee); ?>" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="trade_amount" class="form-label"> <?php echo app('translator')->get('Trade Amount'); ?> <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="trade_amount" name="trade_amount" step="any" placeholder="Enter Trade Amount" value="<?php echo e($competition->trade_amount); ?>" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="per_trade_amount" class="form-label"> <?php echo app('translator')->get('Per Trade Amount'); ?> <sup class="text-danger">*</sup></label>
                                    <div class="input-group">
										<div class="input-group-text">
											₹
										</div>
										<input type="number" class="form-control" id="per_trade_amount" name="per_trade_amount" step="any" placeholder="Enter Per Trade Amount" value="<?php echo e($competition->per_trade_amount); ?>" required="">
									</div>
                                </div>

                                <div class="mb-3 col-lg-6 col-md-12">
                                    <label for="number_of_participants" class="form-label"> <?php echo app('translator')->get('Participants'); ?> <sup class="text-danger">*</sup></label>
                                    <input type="number" class="form-control" name="number_of_participants" id="number_of_participants" value="<?php echo e($competition->number_of_participants); ?>" placeholder="<?php echo app('translator')->get('Enter Participants Number'); ?>" required>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label for="status"><?php echo app('translator')->get('Status'); ?> <sup class="text-danger">*</sup></label>
                                    <select class="form-select" name="status" id="status" required>
                                        <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status); ?>" <?php if($competition->status == $status): ?> selected <?php endif; ?>><?php echo e(replaceInputTitle($key)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
								
                                <div class="form-group mb-3 col-lg-4 col-md-12">
									<label for="parameter" class="form-label"><?php echo e(__('Trade Expiry Time')); ?></label>
									<select class="form-select" id="parameter" name="trade_expiry_time" required>
										<option value=""><?php echo e(__('Select Expiration Time')); ?></option>
										<?php $__currentLoopData = $parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($parameter->id); ?>" <?php if($competition->trade_expiry_time == $parameter->id): ?> selected <?php endif; ?>>
												<?php echo e(__('Time')); ?>: <?php echo e($parameter->time.' ' .\App\Enums\Trade\TradeParameterUnit::getName($parameter->unit)); ?>

											</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
                                </div>
								
                                <div class="form-group mb-3 col-lg-4 col-md-12">
									<label for="ranking_id" class="form-label"><?php echo e(__('Ranking Id')); ?></label>
									<select class="form-select" id="ranking_id" name="ranking_id" required>
										<option value=""><?php echo e(__('Select Ranking')); ?></option>
										<?php $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ranking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($ranking->participant_count); ?>" <?php if($competition->ranking_id == $ranking->participant_count): ?> selected <?php endif; ?>><?php echo e($ranking->participant_count); ?>

											</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
                                </div>
								
								<div class="mb-3 col-lg-4 col-md-12">
                                    <label for="rules" class="form-label"> <?php echo app('translator')->get('Rules'); ?></label>
									<textarea class="form-control" name="rules" id="rules" placeholder="<?php echo app('translator')->get('Enter Rules'); ?>"><?php echo e($competition->rules); ?></textarea>
                                </div>
                            </div>
                        </div>
						
                        <button class="i-btn btn--primary btn--lg"><?php echo app('translator')->get('Submit'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/competition/edit.blade.php ENDPATH**/ ?>