<?php
    $totalProfit = 0;
    $totalLoss = 0;
    $sumProfitDifference = 0.0;
    $sumLossDifference = 0.0;

    foreach($tradeLogs as $tradeLog) {
        $priceWas = $tradeLog->original_price;
        $resultPrice = $tradeLog->meta['result_price'] ?? $tradeLog->result_price;
        $difference = $resultPrice - $priceWas;

        if ($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::WIN->value) {
            $totalProfit++;
            $sumProfitDifference += abs(number_format($difference, 6, '.', ''));
        } elseif ($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::LOSE->value) {
            $totalLoss++;
            $sumLossDifference += abs(number_format($difference, 6, '.', ''));
        }
    }

    $result = number_format($sumProfitDifference - $sumLossDifference, 6, '.', '');
    $resultFormatted = number_format(abs($result), 6, '.', '');
    $resultSign = $result >= 0 ? 'text-success' : 'text-danger';
    $resultPrefix = $result >= 0 ? '+' : '-';
    $sumProfitDifferenceFormatted = number_format($sumProfitDifference, 6, '.', '');
    $sumLossDifferenceFormatted = number_format($sumLossDifference, 6, '.', '');
?>

<div class="card-container">
    <div class="card">
        <div class="i-card1-sm shadow-none rounded-3">
            <h7 class="card-title"><?php echo e(__('Total Profit Trades:')); ?></h7>
            <p class="card-text text-success"><?php echo e($totalProfit); ?></p>
        </div>
    </div>
    <div class="card">
        <div class="i-card1-sm shadow-none rounded-3">
            <h7 class="card-title"><?php echo e(__('Total Loss Trades:')); ?></h7>
            <p class="card-text text-danger"><?php echo e($totalLoss); ?></p>
        </div>
    </div>
    <div class="card">
        <div class="i-card1-sm shadow-none rounded-3">
            <h7 class="card-title"><?php echo e(__('Virtual Profit:')); ?></h7>
            <p class="card-text text-success"><?php echo e(getCurrencySymbol()); ?><?php echo e($sumProfitDifferenceFormatted); ?></p>
        </div>
    </div>
    <div class="card">
        <div class="i-card1-sm shadow-none rounded-3">
            <h7 class="card-title"><?php echo e(__('Virtual Loss:')); ?></h7>
            <p class="card-text text-danger"><?php echo e(getCurrencySymbol()); ?><?php echo e($sumLossDifferenceFormatted); ?></p>
        </div>
    </div>
    <div class="card">
        <div class="i-card1-sm shadow-none rounded-3">
            <h7 class="card-title"><?php echo e(__('Result (Profit/Loss):')); ?></h7>
            <p class="card-text <?php echo e($resultSign); ?>"><?php echo e(getCurrencySymbol()); ?><?php echo e($resultPrefix); ?><?php echo e($resultFormatted); ?></p>
        </div>
    </div>
</div>


<div table id="myTable" class="table">
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th><?php echo e(__('Initiated At')); ?></th>
                    <th><?php echo e(__('Trade Amount')); ?></th>
                    <th><?php echo e(__('Trade Type')); ?></th>
                    <th><?php echo e(__('Price Was')); ?></th>
                    <th><?php echo e(__('Virtual Purchase')); ?></th> <!-- New column -->
                    <th><?php echo e(__('Result Price')); ?></th>
                    <th><?php echo e(__('Profit/Loss')); ?></th>
                    <th><?php echo e(__('Outcome')); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $tradeLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tradeKey => $tradeLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $priceWas = $tradeLog->original_price;
                    $resultPrice = $tradeLog->meta['result_price'] ?? $tradeLog->result_price;
                    $difference = $resultPrice - $priceWas;
                    $differenceFormatted = number_format(abs($difference), 6);
                    $isProfit = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::WIN->value;
                    $isDraw = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::DRAW->value;
                    $isInitiated = $tradeLog->outcome == \App\Enums\Trade\TradeOutcome::INITIATED->value;
                    $purchasedVolume = $tradeLog->amount / $priceWas;
                    $purchasedVolumeFormatted = number_format($purchasedVolume, 6);
                ?>
                <tr>
                    <td data-label="Initiated At"><?php echo e(diffForHumans($tradeLog->created_at)); ?></td>
                    <td data-label="Amount"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount)); ?></td>
                    <td data-label="Volume">
                        <span class="i-badge <?php echo e(\App\Enums\Trade\TradeVolume::getColor($tradeLog->volume)); ?>">
                            <?php echo e(\App\Enums\Trade\TradeVolume::getName($tradeLog->volume)); ?>

                        </span>
                    </td>
                    <td data-label="Price"><?php echo e(getCurrencySymbol()); ?><?php echo e(number_format($priceWas, 6)); ?></td>
                    <td data-label="Purchased Volume"><?php echo e($purchasedVolumeFormatted); ?></td> <!-- New column data -->
                    <td data-label="Result Price"><?php echo e(getCurrencySymbol()); ?><?php echo e(number_format($resultPrice, 6)); ?></td>
                    <td data-label="Difference">
                        <?php if($isInitiated): ?>
                            <?php echo e(__('N/A')); ?>

                        <?php else: ?>
                            <span class="<?php echo e($isProfit ? 'text-success' : ($isDraw ? 'text-purple' : 'text-danger')); ?>">
                                <?php echo e($isProfit ? '+' : ($isDraw ? '' : '-')); ?><?php echo e(getCurrencySymbol()); ?><?php echo e($differenceFormatted); ?>

                            </span>
                        <?php endif; ?>
                    </td>
                    <td data-label="Outcome">
                        <span class="i-badge <?php echo e(\App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome)); ?>">
                            <?php echo e(\App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome)); ?>

                        </span>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="text-muted text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.card-container {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-bottom: 1rem;
}

.card {
    flex: 1;
    min-width: 200px;
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 0.25rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.card-body {
    padding: 1rem;
}
</style>
<?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/partials/trade/trade-log.blade.php ENDPATH**/ ?>