<div class="row align-items-center gy-4">
    <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6">
            <div class="pricing-item style-two">
                <?php if($investment->is_recommend): ?>
                    <div class="recommend">
                        <span><?php echo e(__('Recommend')); ?></span>
                    </div>
                <?php endif; ?>

                <div class="header">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="title"><?php echo e($investment->name); ?></h4>
                        <?php if($investment->interest_return_type == \App\Enums\Investment\ReturnType::REPEAT->value): ?>
                            <div class="price mt-0"><?php echo e((int)$investment->duration); ?> <?php echo e($investment->timeTable->name ?? ''); ?></div>
                        <?php else: ?>
                            <div class="price mt-0"><?php echo e(__('Lifetime')); ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="d-flex justify-content-between flex-wrap align-items-center gap-2">
                        <p class="text-start fs-16 mb-0"><?php echo e(__('Interest Rate')); ?>: <span class="text--dark"> <?php echo e(shortAmount($investment->interest_rate)); ?><?php echo e(\App\Enums\Investment\InterestType::getSymbol($investment->interest_type)); ?> </span></p>
                        <button class="fs-15 terms-policy bg-transparent" type="button"
                            data-bs-toggle="modal"
                            data-bs-target="#termsModal"
                            data-terms_policy="<?php echo $investment->terms_policy ?>"
                        >
                            <i class="bi bi-info-circle me-2 color--primary"></i><?php echo e(__('Terms and Policies')); ?>

                        </button>
                    </div>
                </div>
                <div class="body">
                    <h6 class="mb-4">
                        <span class="text--light">
                            <?php echo e(__('Investment amount limit')); ?>

                        </span> : <?php if($investment->type == \App\Enums\Investment\InvestmentRage::RANGE->value): ?>
                            <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->minimum)); ?>

                            - <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->maximum)); ?>

                        <?php else: ?>
                            <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investment->amount)); ?>

                        <?php endif; ?>
                    </h6>
                    <ul class="pricing-list">
                        <?php if(!empty($investment->meta)): ?>
                            <?php $__currentLoopData = $investment->meta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <span><?php echo e($value); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                    <h6 class="mb-4">
                        <span class="text-end text--light"><?php echo e(__('Total Return')); ?></span> :
                        <?php if($investment->interest_return_type == \App\Enums\Investment\ReturnType::REPEAT->value): ?>
                            <?php echo e(totalInvestmentInterest($investment)); ?>

                        <?php else: ?>
                            <?php echo app('translator')->get('Unlimited'); ?>
                        <?php endif; ?>

                        <?php if($investment->recapture_type == \App\Enums\Investment\Recapture::HOLD->value): ?>
                            <span class="d-inline-block" tabindex="0" data-bs-toggle="tooltip" title="Hold capital & reinvest">
                                  <i class="bi bi-info-circle me-2 color--primary"></i>
                            </span>
                        <?php endif; ?>
                    </h6>
                </div>
                <div class="footer">
                    <button
                        class="i-btn btn--dark btn--lg capsuled w-100 invest-process"
                        data-bs-toggle="modal"
                        data-bs-target="#investModal"
                        data-name="<?php echo e($investment->name); ?>"
                        data-uid="<?php echo e($investment->uid); ?>"
                    ><?php echo e(__('Invest Now')); ?></button>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<div class="modal fade" id="termsModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header primary--light border-0">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Terms and policy')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="invest_terms"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--danger btn--md" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="investModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header primary--light border-0">
                <h5 class="modal-title" id="investTitle"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <form method="POST" action="<?php echo e(route('user.investment.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="uid" value="">
                <div class="modal-body">

                    <div class="mb-3">
                        <label for="amount" class="col-form-label"><?php echo e(__('Amount')); ?></label>
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" id="amount" name="amount"
                                   placeholder="<?php echo e(__('Enter Invest amount')); ?>"
                                   aria-label="Recipient's username" aria-describedby="basic-addon2">
                            <span class="input-group-text" id="basic-addon2"><?php echo e(getCurrencyName()); ?></span>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="i-btn btn--primary btn--md"><?php echo e(__('Submit')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $('.invest-process').click(function () {
                const name = $(this).data('name');
                const uid = $(this).data('uid');
                $('input[name="uid"]').val(uid);

                const title = "Start Investing with the " + name + " Plan";
                $('#investTitle').text(title);
            });

            $('.terms-policy').click(function () {
                const terms = $(this).data('terms_policy');
                $('#invest_terms').text(terms);
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/partials/investment/plan.blade.php ENDPATH**/ ?>