@extends('layouts.main')

@section('content')
    @include('frontend.partials.breadcrumb', ['setTitle' => $setTitle])
    <main>
        <div class="trading-section pt-110 pb-110 bg-color">
            <div class="container i-container">
                <div class="row g-4">
                    <div class="col-xl-9 pe-lg-4">
                        <div class="market-graph">
                            <div class="mb-5">
                                <!-- Button to open TradingView in popup -->
                                <button id="openModalBtn" class="btn btn-primary">Open TradingView Chart</button>
                            </div>
                            @include('user.partials.trade.trade-log')
                        </div>
                    </div>
                    <div class="col-xl-3">
                        @include('user.partials.trade.binary-trade')
                        @include('user.partials.trade.market')
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Popup Modal -->
    <div id="myModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div class="tradingview-widget-container p-2 bg-color-2" id="chartContainer" style="width: 100%; height: 500px;">
                <div class="tradingview-widget-container__widget"></div>
            </div>
        </div>
    </div>
@endsection

@push('script-push')
    <script>
        'use strict';
        $(document).ready(function() {
            // Handle click on open modal button
            $("#openModalBtn").on('click', function() {
                $("#myModal").css("display", "block"); // Show modal

                // Load TradingView chart
                loadTradingViewChart();
            });

            // Handle click on close button or outside modal to close it
            $(".close, #myModal").on('click', function() {
                $("#myModal").css("display", "none"); // Hide modal
            });

            // Function to load TradingView chart
            function loadTradingViewChart() {
                var chartContainer = document.getElementById('chartContainer');
                chartContainer.innerHTML = ''; // Clear previous content if any

                var script = document.createElement('script');
                script.type = 'text/javascript';
                script.async = true;
                script.src = 'https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js';
                script.innerHTML = JSON.stringify({
                    "autosize": true,
                    "width": "100%",
                    "height": 500,
                    "symbol": "BITBNS:{{ strtoupper($crypto->symbol) }}{{ strtoupper(getCurrencyName()) }}",
                    "interval": "1",
                    "timezone": "Asia/Kolkata",
                    "theme": "dark",
                    "style": "3",
                    "locale": "en",
                    "enable_publishing": true,
                    "hide_legend": true,
                    "withdateranges": true,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "details": true,
                    "hotlist": true,
                    "calendar": false,
                    "support_host": "https://www.tradingview.com"
                });
                chartContainer.appendChild(script);
            }
        });
    </script>
@endpush



@push('script-push')
    <script>
        'use strict';
        $(document).ready(function() {
            $("#amount").on('keyup', function() {
                const inputAmount = parseFloat($(this).val());
                const commissionPercentage = {{ getArrayValue($setting->commissions_charge, 'binary_trade_commissions', 0) }};

                if (isNaN(inputAmount)) {
                    $("#profit_amount").text('+' + 0.00);
                    return;
                }

                const profit = (commissionPercentage / 100) * inputAmount;
                const withProfitAmount = parseFloat(inputAmount) + parseFloat(profit);

                $("#profit_amount").text('+' + withProfitAmount.toFixed(2));
            });
        });
    </script>
@endpush






