@extends('admin.layouts.main')
@section('panel')
    <section>
        <div class="container-fluid p-0">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ $setTitle }}</h4>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.generate_ranking.post')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row gy-4 gx-3 mb-4">
                            <div class="col-lg-12 text-right">
								<button class="i-btn btn--primary btn--lg">{{ __('admin.button.update') }}</button>
							</div>
                            <div class="col-lg-4">
                                <label class="form-label" for="participants">{{ __('Participants') }} <sup class="text-danger">*</sup></label>
                                <select class="form-select" id="participants" name="participants">
                                    <option value="" selected>{{ __('Select Participants') }}</option>
                                    @foreach(ranking_participants() as $key =>  $val)
                                        <option value="{{ $val }}" @if($val == $request->participants) selected @endif>{{ $val }}</option>
                                    @endforeach
                                </select>
								@error('participants')
									<span class="text-danger">{{$message}}</span>
								@enderror
                            </div>
                            <div class="col-lg-4">                                
                                <div class="form-group">
									@if(isset($rankings_value->admin_fees) && $rankings_value->admin_fees != '')
										@php
										$admin_feess = $rankings_value->admin_fees;
										@endphp
									@else
										@php
										$admin_feess = '';
										@endphp
									@endif
									<label class="form-label" for="admin_fees">Admin Fees (%) <sup class="text-danger">*</sup></label>
									<input type="number" name="admin_fees" id="admin_fees" value="{{ $admin_feess }}" class="form-control">
                                </div>
								@error('admin_fees')
									<span class="text-danger">{{$message}}</span>
								@enderror
                            </div>						
                        </div>
						@if($request->participants > 0)
                        <div class="row gy-4 gx-3 mb-4">
                            <h5 class="mt-5 mb-0">{{__('admin.generate_ranking.page_title.name')}}</h5>
                            @for ($i = 0; $i < $request->participants; $i++)
                                <div class="form-group col-lg-4">
									<label class="form-label" for="rank_from{{$i}}">{{ __('Rank From') }}</label>
									<input type="number" name="rank_from[]" id="rank_from{{$i}}" value="{{isset($rankings[$i]) ? $rankings[$i]['rank_from'] : '' }}" class="form-control">
                                </div>
                                <div class="form-group col-lg-4">
									<label class="form-label" for="rank_to{{$i}}">{{ __('Rank To') }}</label>
									<input type="number" name="rank_to[]" id="rank_to{{$i}}" value="{{isset($rankings[$i]) ? $rankings[$i]['rank_to'] : '' }}" class="form-control">
                                </div>
                                <div class="form-group col-lg-4">
									<label class="form-label" for="percentage{{$i}}">{{ __('Percentage') }} (%)</label>
									<input type="number" name="percentage[]" id="percentage{{$i}}" value="{{isset($rankings[$i]) ? $rankings[$i]['percentage'] : '' }}" class="form-control" step="0.01" min="0">
                                </div>
                            @endfor
                        </div>
                        <button class="i-btn btn--primary btn--lg">{{ __('admin.button.update') }}</button>
						@endif
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('script-push')
    <script>
		$('#participants').on('change', function() {
			var p_id = $(this).val();
			window.location.href = "{{ route('admin.generate_ranking')}}?participants="+p_id;
		});
    </script>
@endpush



