<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Models\User;
use App\Enums\Email\EmailSmsTemplateName;
use App\Jobs\SendSmsVerificationJob;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class PhoneVerificationController extends Controller
{
    public function show(Request $request)
    {
        return $request->user()->hasVerifiedPhone()
                        ? redirect()->intended(RouteServiceProvider::HOME)
                        : view('auth.verifyphone');
    }

    public function verify(Request $request)
    {
        if ($request->user()->verification_code !== $request->code) {
            throw ValidationException::withMessages([
                'code' => ['The code your provided is wrong. Please try again.'],
            ]);
        }

        if ($request->user()->hasVerifiedPhone()) {
            return redirect()->intended(RouteServiceProvider::HOME);
        }

        $request->user()->markPhoneAsVerified();

		return redirect()->intended(RouteServiceProvider::HOME)->with('notify', [['success', "Your phone was successfully verified!"]]);
    }
    public function resend(Request $request)
    {
		$code = random_int(100000, 999999);
		$user = Auth::user();
		$user->verification_code = $code;
		$user->save();
		
        dispatch(new SendSmsVerificationJob($user, [
			'otp' => $code,
		], $code, EmailSmsTemplateName::PHONE_NUMBER_VERIFICATION->value));

        return back()->with('notify', [['success', "Successfully sent verification code on your number."]]);
    }
}
