<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="i-card-sm mb-4 p-3">
            <div class="input-group">
                <input type="text" class="form-control reference-url" value="<?php echo e(route('home', ['reference' => \Illuminate\Support\Facades\Auth::user()->uuid])); ?>" aria-label="Recipient's username" aria-describedby="reference-copy" readonly>
                <span class="input-group-text bg--primary text-white" id="reference-copy"><?php echo e(__('Copy')); ?><i class="las la-copy ms-2"></i></span>
            </div>
        </div>
        
      
        <div class="i-card-sm mb-4">
            <div class="row g-4">
                
               <!-- New KYC Status Card -->
                <div class="col-12">
                    <div class="i-card-sm card-style purple rounded-3">
                        
                        <div class="card-info text-center">
                            <div class="row">
                                <!-- KYC Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->kyc_status == 1 ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('KYC Status')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->kyc_status == 1 ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->kyc_status == 1 ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                </div>
                                <!-- Email Verification Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->email_verified_at ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('Email')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->email_verified_at ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->email_verified_at ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                    <?php if($user->email_verified_at): ?>
                                        <span class="text-muted ms-2">(<?php echo e($user->email_verified_at); ?>)</span>
                                    <?php endif; ?>
                                </div>
                                <!-- Phone Verification Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->phone_verified_at ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('Mobile')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->phone_verified_at ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->phone_verified_at ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                    <?php if($user->phone_verified_at): ?>
                                        <span class="text-muted ms-2">(<?php echo e($user->phone_verified_at); ?>)</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of New KYC Status Card -->
                
                
               
                
                
                
<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
    <div class="i-card-sm card-style purple rounded-3">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="title text--purple mb-4"><?php echo e(__('Competition')); ?></h5>
            <div class="avatar--lg bg--purple">
                <i class="bi bi-trophy text-white"></i>
            </div>
        </div>

        <div class="card-info text-center">
            <ul class="user-card-list w-100">
                <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                    <span class="fw-bold"><?php echo e(__('Live Competitions')); ?></span>
                    <span class="fw-bold text--dark"><?php echo e($liveCompetitions); ?></span>
                </li>
                <li class="d-flex align-items-center justify-content-between gap-3 mb-2">
                    <span class="fw-bold"><?php echo e(__('Total Competitions')); ?></span>
                    <span class="fw-bold text--dark"><?php echo e($totalCompetitions); ?></span>
                </li>
                
                <li class="d-flex align-items-center justify-content-between gap-3">
                    <span class="fw-bold"><?php echo e(__('Completed Competitions')); ?></span>
                    <span class="fw-bold text--dark"><?php echo e($completedCompetitions); ?></span>
                </li>
            </ul>
            <a href="<?php echo e(route('user.competition.index')); ?>" class="btn--white"><?php echo e(__('Competitions')); ?><i class="bi bi-box-arrow-up-right ms-2"></i></a>
        </div>
    </div>
</div>


                
                <!--
                 <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                    <div class="i-card-sm card-style purple rounded-3">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="title text--purple mb-4"><?php echo e(__('Competetion')); ?></h5>
                            <div class="avatar--lg bg--purple">
                                <i class="bi bi-credit-card text-white"></i>
                            </div>
                        </div>

                        <div class="card-info text-center">
                            <ul class="user-card-list w-100">
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('Live Competetions')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->total)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('Total Competetions')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->profit)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold"><?php echo e(__('Paticipated')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->running)); ?></span>
                                </li>
                            </ul>
                            <a href="<?php echo e(route('user.investment.index')); ?>" class="btn--white"><?php echo e(__('frontend.dashboard.investment.now')); ?><i class="bi bi-box-arrow-up-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
                -->
                
                
                

                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                    <div class="i-card-sm card-style blue rounded-3">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="title text--blue mb-4"><?php echo e(__('Subscription')); ?></h5>
                            <div class="avatar--lg bg--blue">
                                <i class="bi bi-wallet text-white"></i>
                            </div>
                        </div>
                        <div class="card-info text-center">
                            <ul class="user-card-list mb-4 w -100">
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('Total Rewards')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(@$matrixInvest->referral_commissions + @$matrixInvest->level_commissions)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('Referal Rewards')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(@$matrixInvest->referral_commissions)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold"><?php echo e(__('All Referal Rewards')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(@$matrixInvest->level_commissions)); ?></span>
                                </li>
                            </ul>
                            <a href="<?php echo e(route('user.matrix.index')); ?>" class="btn--white"><?php echo e(__('frontend.dashboard.matrix.enrolled')); ?><i class="bi bi-box-arrow-up-right ms-2"></i></a>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                    <div class="i-card-sm card-style yellow rounded-3">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="title mb-0 text--yellow"><?php echo e(__('frontend.dashboard.trade.index')); ?></h5>
                            <div class="avatar--lg bg--yellow">
                                <i class="bi bi-bar-chart text-white"></i>
                            </div>
                        </div>

                        <div class="card-info text-center">
                            <ul class="user-card-list w-100">
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.trade.total')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeReport->total)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.trade.wining')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeReport->wining)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold"><?php echo e(__('frontend.dashboard.trade.loss')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeReport->loss)); ?></span>
                                </li>
                            </ul>
                            <a href="<?php echo e(route('user.trade.index')); ?>" class="btn--white"><?php echo e(__('Start Trading')); ?> <i class="bi bi-box-arrow-up-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        

       <div class="row g-4 mb-4">
    <div class="col-lg-6">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm green">
                <div class="card-info">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5 class="title"><?php echo e(__('Rewards')); ?></h5>
                        <a class="arrow--btn" href="<?php echo e(route('user.referral.index')); ?>"><?php echo e(__('Referral Rewards')); ?> <i class="bi bi-arrow-right-short"></i></a>
                    </div>
                     <div class="total-balance-wrapper">
                         
                        
                        
                    <div class="total-balance">
                        <p><?php echo e(__('Referral Balance')); ?></p>
                        <div class="d-flex gap-2">
                            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(getArrayValue($commissions, 'referral'))); ?></h4>
                        </div>
                        
                    </div>
                    <div class="total-balance">
                        <p><?php echo e(__('All Referrals')); ?></p>
                        <div class="d-flex gap-2">
                            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(getArrayValue($commissions, 'level'))); ?></h4>
                        </div>
                    </div>
                    <div class="total-balance">
                        <p><?php echo e(__('Reward Balance')); ?></p>
                        <div class="d-flex gap-2">
                            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->reward_balance)); ?></h4>
                        </div>
                    </div>
  
  
<?php if(Auth::user()->is_franchisee): ?>
    <div class="total-balance">
        <p><?php echo e(__('Total Franchisee Commission')); ?></p>
        <div class="d-flex gap-2">
            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($totalFranchiseeCommission)); ?></h4>
        </div>
    </div>
<?php endif; ?>



                </div>
            </div>
        </div>
    </div>
    </div>

    <div class="col-lg-6">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm pink">
                <div class="card-info">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5 class="title"><?php echo e(__('Balance')); ?></h5>
                        <a class="arrow--btn" href="<?php echo e(route('user.wallet.index')); ?>"><?php echo e(__('Balance Transfer')); ?> <i class="bi bi-arrow-right-short"></i></a> 
                    </div>
                    <div class="total-balance-wrapper">
                        <div class="total-balance">
                            <p><?php echo e(__('Primary Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->primary_balance)); ?></h4>
                            </div>
                        </div>
                        
                        
                        <div class="total-balance">
                            <p><?php echo e(__('Trade Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->trade_balance)); ?></h4>
                            </div>
                        </div>
                        <div class="total-balance">
                            <p><?php echo e(__('Virtual Trade Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->virtual_trade_balance)); ?></h4>
                            </div>
                        </div>
                        <div class="total-balance">
                            <p><?php echo e(__('Referral Reward Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount((getArrayValue($commissions, 'referral'))+(getArrayValue($commissions, 'level'))+(Auth::user()?->wallet->reward_balance))); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(Auth::user()->is_franchisee): ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="i-card-sm">
                <div class="card-header">
                    <h4 class="title"><?php echo e(__("Franchisee Commission Details")); ?></h4>
                </div>
                <?php echo $__env->make('user.partials.commission', ['commission_details' => $commission_details, 'is_paginate' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>



        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            const depositMonthAmount = <?php echo json_encode($depositMonthAmount, 15, 512) ?>;
            const withdrawMonthAmount = <?php echo json_encode($withdrawMonthAmount, 15, 512) ?>;
            const months = <?php echo json_encode($months, 15, 512) ?>;
            const currency = "<?php echo e(getCurrencySymbol()); ?>";

            const options = {
                series: [
                    {
                        name: 'Total Deposits Amount',
                        data: depositMonthAmount
                    },
                    {
                        name: 'Total Withdraw Amount',
                        data: withdrawMonthAmount
                    }
                ],
                chart: {
                    height: 530,
                    type: 'line',
                    toolbar: false,
                    zoom: {
                        enabled: false
                    }
                },
                plotOptions: {
                    bar: {
                        borderRadius: 10,
                        dataLabels: {
                            position: 'bottom',
                        },
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function (val, opts) {
                        return '';
                    },
                    offsetY: -20,
                    style: {
                        fontSize: '12px',
                        colors: ["#304758"]
                    }
                },
                xaxis: {
                    categories: months,
                    position: 'top',
                    axisBorder: {
                        show: false
                    },
                    axisTicks: {
                        show: false
                    },
                    crosshairs: {
                        fill: {
                            type: 'gradient',
                            gradient: {
                                colorFrom: '#D8E3F0',
                                colorTo: '#BED1E6',
                                stops: [0, 100],
                                opacityFrom: 0.4,
                                opacityTo: 0.5,
                            }
                        }
                    },
                    tooltip: {
                        enabled: true,
                    }
                },
                yaxis: {
                    axisBorder: {
                        show: false
                    },
                    axisTicks: {
                        show: false,
                    },
                    labels: {
                        show: false,
                        formatter: function (val) {
                            return currency + val;
                        }
                    }
                },
                title: {
                    floating: true,
                    offsetY: 340,
                    align: 'center',
                    style: {
                        color: '#222',
                        fontWeight: 600
                    }
                }
            };

            const chart = new ApexCharts(document.querySelector("#monthlyChart"), options);
            chart.render();

            $('#reference-copy').click(function() {
                var copyText = $('.reference-url');
                copyText.select();
                document.execCommand('copy');
                copyText.blur();
                notify('success', 'Copied to clipboard!');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/dashboard.blade.php ENDPATH**/ ?>