<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Competition extends Model
{
    use HasFactory;

    protected $table = 'competitions';

    protected $fillable = [
        'title',
        'start_time',
        'end_time',
        'prize_pool_amt',
        'entry_fee',
        'trade_amount',
        'per_trade_amount',
        'number_of_participants',
        'trade_expiry_time',
        'ranking_id',
        'is_rewarded',
        'rules',
        'status',
    ];
	public function participants()
    {
        return $this->hasMany(CompetitionParticipants::class, 'competition_id', 'id');
    }
}
