<div class="card-body">
    <div class="row align-items-center gy-4 mb-3">
        <div class="table-container">
            <table id="myTable" class="table">
                <thead>
                    <tr>
                        <th scope="col"><?php echo e(__('Joined At')); ?></th>
                        <th scope="col"><?php echo e(__('Subscription Name')); ?></th>
                        <th scope="col"><?php echo e(__('Subscription Price')); ?></th>
                        <th scope="col"><?php echo e(__('Subscription User')); ?></th>
                        <th scope="col"><?php echo e(__('Subscription Code')); ?></th>
                        <th scope="col"><?php echo e(__('Commission Amount')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $commission_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td data-label="<?php echo e(__('Joined At')); ?>"><?php echo e(showDateTime($item->created_at)); ?></td>
                            <td data-label="<?php echo e(__('Subscrition Name')); ?>">
                                <?php if($item->matrix_invest): ?>
                                    <?php echo e($item->matrix_invest->name); ?>

                                <?php else: ?>
                                    <?php echo e(__('N/A')); ?>

                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo e(__('Subscrition Price')); ?>">
                                <?php if($item->matrix_invest): ?>
                                    <?php echo e(shortAmount($item->matrix_invest->price)); ?>

                                <?php else: ?>
                                    <?php echo e(__('N/A')); ?>

                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo e(__('Subscrition User')); ?>">
                                <?php if($item->matrix_invest && $item->matrix_invest->user): ?>
                                    <?php echo e($item->matrix_invest->user->first_name); ?>

                                <?php else: ?>
                                    <?php echo e(__('N/A')); ?>

                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo e(__('Subscrition Code')); ?>">
                                <?php if($item->matrix_invest): ?>
                                    <?php echo e($item->matrix_invest->pin_number); ?>

                                <?php else: ?>
                                    <?php echo e(__('N/A')); ?>

                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo e(__('Commission Amount')); ?>">
                                <?php echo e(shortAmount($item->franchaisee_commission_amount)); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if($is_paginate): ?>
    <div class="mt-4"><?php echo e($commission_details->links()); ?></div>
<?php endif; ?>
<?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/partials/commission.blade.php ENDPATH**/ ?>