@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">{{ __($setTitle) }}</h4>
                    </div>
                    <div class="market-graph">
                        <div class="mb-5">
                            @include('user.partials.trade.trading-view')
                        </div>
                        <div class="mb-5">
                            @include('user.partials.trade.binary-trade')
                        </div>
                        <div class="mb-5">
                            @include('user.partials.trade.trade-log')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script-push')
    <script>
        'use strict';
        $(document).ready(function() {
            $("#amount").on('keyup', function() {
                const inputAmount = parseFloat($(this).val());
                const commissionPercentage = {{ getArrayValue($setting->commissions_charge, 'binary_trade_commissions', 0) }};

                if (isNaN(inputAmount)) {
                    $("#profit_amount").text('+' + 0.00);
                    return;
                }

                const profit = (commissionPercentage / 100) * inputAmount;
                const withProfitAmount = parseFloat(inputAmount) + parseFloat(profit);

                $("#profit_amount").text('+' + withProfitAmount.toFixed(2));
            });
        });
    </script>
@endpush






