<?php $__env->startSection('panel'); ?>
	<style>
		.nav-link {
			padding: 0.5rem 1rem !important;
		}
	</style>
	<section>
		<h3 class="page-title"><?php echo e(__('Competition Details')); ?></h3>
        <div class="row">
            <div class="col-lg-12 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white"><?php echo e($competition_details->title); ?></h4>
						<button class="i-btn btn--warning btn--md competitionRules"><?php echo e(__('Contest Rules')); ?></button>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Prize Pool')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?> <?php echo e(number_format($competition_details->prize_pool_amt, 0)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Entry Fee')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?> <?php echo e(number_format($competition_details->entry_fee, 0)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Virtual Trade Amount')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?> <?php echo e(number_format($competition_details->trade_amount, 0)); ?></span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Amount Per Virtual Trade')); ?>

                                <span>
                                    <?php echo e(getCurrencySymbol()); ?> <?php echo e(number_format($competition_details->per_trade_amount, 0)); ?>

                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-header bg--primary">
                        <h4 class="card-title text-white"><?php echo e(__('Other Information')); ?></h4>
                    </div>

                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Participants')); ?>

                                <span><?php echo e(count($competition_details->participants)); ?>/<?php echo e($competition_details->number_of_participants); ?></span>
                            </li>
							
							<?php
								$dateString = $competition_details->end_time;
								$endDate = \Carbon\Carbon::parse($dateString);
								$now = \Carbon\Carbon::now();
								$diff = $endDate->diff($now);
								$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
							?>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Ends In')); ?>

                                <?php if($now > $competition_details->end_time): ?>
									<span><?php echo e(__('Expired')); ?></span>
								<?php else: ?>
									<span><?php echo e($duration); ?></span>
								<?php endif; ?>
                            </li>

							<?php
								$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $competition_details->start_time);
								$startTime = $startTime->format('F, j (H:i)');
							?>
                            <li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <?php echo e(__('Started At')); ?>

                                <span><?php echo e($startTime); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 mb-4">
                <div class="card">
                    <div class="card-header">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
							<li class="nav-item" role="presentation">
								<button class="nav-link active" id="leaderboard-tab" data-bs-toggle="pill" data-bs-target="#leaderboard" type="button" role="tab" aria-controls="leaderboard" aria-selected="true">Leaderboard</button>
							</li>
							<li class="nav-item" role="presentation">
								<button class="nav-link" id="participants-tab" data-bs-toggle="pill" data-bs-target="#participants" type="button" role="tab" aria-controls="participants" aria-selected="false">Participants</button>
							</li>
							<li class="nav-item" role="presentation">
								<button class="nav-link" id="virtual-trade-tab" data-bs-toggle="pill" data-bs-target="#virtual-trade" type="button" role="tab" aria-controls="virtual-trade" aria-selected="false">Virtual Trade Logs</button>
							</li>
						</ul>
                    </div>

                    <div class="card-body">
                        <div class="tab-content" id="pills-tabContent">	
							<div class="tab-pane fade show active trading" id="leaderboard" role="tabpanel" aria-labelledby="leaderboard-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th><?php echo e(__('Rank')); ?></th>
													<th><?php echo e(__('Participant')); ?></th>
													<th><?php echo e(__('Trades Completed')); ?></th>
													<th><?php echo e(__('Total Profit')); ?></th>
													<th><?php echo e(__('Total Loss')); ?></th>
													<th><?php echo e(__('Profit Loss Ratio')); ?></th>
													<th><?php echo e(__('Efficiency Ratio')); ?></th>
													<th><?php echo e(__('Reward')); ?></th>
												</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $leaderboard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$leaderboardVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo e(__('Rank')); ?>"><?php echo e($leaderboardVal['rank']); ?></td>
													<td data-label="<?php echo e(__('Participant')); ?>"><?php echo e($leaderboardVal['participant']); ?></td>
													<td data-label="<?php echo e(__('Trades Completed')); ?>"><?php echo e($leaderboardVal['trade_completed']); ?></td>
													<td data-label="<?php echo e(__('Total Profit')); ?>"><?php echo e($leaderboardVal['total_profit']); ?></td>
													<td data-label="<?php echo e(__('Total Loss')); ?>"><?php echo e($leaderboardVal['total_loss']); ?></td>
													<td data-label="<?php echo e(__('Profit Loss Ratio')); ?>"><?php echo e($leaderboardVal['profit_loss_ratio']); ?></td>
													<td data-label="<?php echo e(__('Efficiency Ratio')); ?>"><?php echo e($leaderboardVal['efficiency_ratio']); ?></td>
													<td data-label="<?php echo e(__('Reward')); ?>"><?php echo e($leaderboardVal['reward'] != '-' ? getCurrencySymbol() : ''); ?><?php echo e($leaderboardVal['reward']); ?></td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<td class="text-muted text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<div class="tab-pane fade trading" id="participants" role="tabpanel" aria-labelledby="participants-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th><?php echo e(__('S.No.')); ?></th>
													<th><?php echo e(__('Username')); ?></th>
												</tr>
											</thead>
											<tbody>
											<?php
												$i = 1;
											?>
											<?php $__empty_1 = true; $__currentLoopData = $competition_details->participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant_val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo e(__('S.No.')); ?>"><?php echo e($i); ?></td>
													<td data-label="<?php echo e(__('Username')); ?>"><?php echo e($participant_val->user_details->first_name ?? $participant_val->user_details->first_name); ?> <?php echo e($participant_val->user_details->last_name ?? $participant_val->user_details->last_name); ?></td>
												</tr>
												<?php
													$i++;
												?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<td class="text-muted text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<div class="tab-pane fade trading" id="virtual-trade" role="tabpanel" aria-labelledby="virtual-trade-tab">
								<div class="trade-table scroll-design dark--table">
									<div class="table-container">
										<table>
											<thead>
												<tr>
													<th><?php echo e(__('Initiated At')); ?></th>
													<th><?php echo e(__('Entry Amount')); ?></th>
													<th><?php echo e(__('Volume')); ?></th>
													<th><?php echo e(__('Price Was')); ?></th>
													<th><?php echo e(__('Result Price')); ?></th>
													<th><?php echo e(__('Outcome')); ?></th>
												</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $tradeLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tradeKey => $tradeLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="Initiated At"><?php echo e(diffForHumans($tradeLog->created_at)); ?></td>
													<td data-label="Amount"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount)); ?></td>
													<td data-label="Volume">
														<span class="badge <?php echo e(\App\Enums\Trade\TradeVolume::getColor($tradeLog->volume)); ?>">
															<?php echo e(\App\Enums\Trade\TradeVolume::getName($tradeLog->volume)); ?>

														</span> <!-- ($tradeLog->meta['result_price'], 6) -->
													</td>
													<td data-label="Price"><?php echo e(getCurrencySymbol()); ?><?php echo e(number_format($tradeLog->original_price, 6)); ?></td>
													<td data-label="<?php echo e(__('Result Price')); ?>">
															<?php if($tradeLog->meta != null): ?>
																<?php echo e(getCurrencySymbol()); ?><?php echo e(number_format($tradeLog->meta['result_price'], 6)); ?>

															<?php else: ?>
																<?php echo e(getCurrencySymbol()); ?><?php echo e(number_format($tradeLog->result_price, 6)); ?>

															<?php endif; ?>
														</td>
													<td data-label="Outcome">
														<span class="badge <?php echo e(\App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome)); ?>"><?php echo e(\App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome)); ?></span>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<td class="text-muted text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
	
    
	<div class="modal" id="CompetitionRulesModal" tabindex="-1" aria-labelledby="CompetitionRulesModalLabel">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header primary--light border-0">
					<h5 class="modal-title" id="competitionTitle">Competition Rules</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>				
				<div class="modal-body">
				<?php echo $competition_details->rules; ?>

				</div>
				<div class="modal-footer">
					<button type="button" class="i-btn btn--white btn--sm" data-bs-dismiss="modal" aria-label="Close">Close</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
<script>
$(document).on("click", ".competitionRules", function() {
	$('#CompetitionRulesModal').modal('show');
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/competition/details.blade.php ENDPATH**/ ?>