<?php $__env->startSection('panel'); ?>
    <section>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo e($setTitle); ?></h4>
            </div>

            <div class="card-body">
                <div class="col-lg-12">
                    <?php if(blank($matrixLog)): ?>
                        <h5>There are no enrolled available</h5>
                    <?php else: ?>
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Initiated At')); ?>

                                <span><?php echo e(showDateTime($matrixLog->created_at)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Trx')); ?>

                                <span><?php echo e($matrixLog->trx); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Schema Name')); ?>

                                <span><?php echo e($matrixLog->name); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Invest Amount')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->price)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('User-Based Referral Bonus')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->referral_reward)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Referral Users')); ?>

                                <span><?php echo e($matrixLog?->user?->referredUsers->count()); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Referral Commissions')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->referral_commissions)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Level Commissions')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->level_commissions)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Total Profit')); ?>

                                <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($matrixLog->referral_commissions + $matrixLog->level_commissions)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Status')); ?>

                                <span class="badge <?php echo e(\App\Enums\Matrix\InvestmentStatus::getColor($matrixLog->status)); ?>"><?php echo e(\App\Enums\Matrix\InvestmentStatus::getName($matrixLog->status)); ?></span>
                            </li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/user/matrix-enrolled.blade.php ENDPATH**/ ?>