<?php $__env->startSection('panel'); ?>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><?php echo e(__($setTitle)); ?></h4>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.general.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="<?php echo e(\App\Enums\GeneralSetting::SECURITY->value); ?>">
                <?php $__currentLoopData = $setting->security; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $security): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-wrapper">
                        <div class="row">
                            <h5 class=" mb-2 fs-14"><?php echo e(__(replaceInputTitle($key))); ?></h5>
                            <?php $__currentLoopData = $security; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $security_key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-6 mb-3">
                                    <?php if($security_key == 'status'): ?>
                                        <label for="status-<?php echo e($key); ?>-<?php echo e($security_key); ?>" class="form-label"><?php echo e(__($security_key)); ?> <sup class="text-danger">*</sup></label>
                                        <select class="form-select" id="status-<?php echo e($key); ?>-<?php echo e($security_key); ?>" name="security[<?php echo e($key); ?>][<?php echo e($security_key); ?>]" required>
                                            <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($status); ?>" <?php if($status == $value): ?> selected <?php endif; ?>><?php echo e(replaceInputTitle($status_key)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php elseif(in_array($security_key, ['frequency', 'period'])): ?>
                                        <label for="<?php echo e($security_key); ?>" class="form-label"><?php echo e(__(replaceInputTitle($security_key))); ?> <sup class="text-danger">*</sup></label>
                                        <div class="input-group">
                                            <input type="text" name="security[<?php echo e($key); ?>][<?php echo e($security_key); ?>]" value="<?php echo e($value); ?>" class="form-control" id="<?php echo e($security_key); ?>" required>
                                            <span class="input-group-text"><?php echo e(__($security_key == 'frequency' ? 'Seconds' : 'Minutes')); ?></span>
                                        </div>
                                    <?php else: ?>
                                        <label for="<?php echo e($security_key); ?>" class="form-label"><?php echo e(__(replaceInputTitle($security_key))); ?> <sup class="text-danger">*</sup></label>
                                        <input type="text" name="security[<?php echo e($key); ?>][<?php echo e($security_key); ?>]" value="<?php echo e($value); ?>" class="form-control" id="<?php echo e($security_key); ?>" required>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button class="i-btn btn--primary btn--lg"><?php echo e(__('admin.button.save')); ?></button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $('.keywords').select2({
            tags: true,
            tokenSeparators: [',']
        });
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/setting/security.blade.php ENDPATH**/ ?>