<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="row g-4 mb-4">
            <div class="col-lg-4">
                <div class="i-card-sm p-3">
                    <div class="i-card-sm card-style purple rounded-3">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="title text--purple mb-4"><?php echo e(__('frontend.dashboard.investment.index')); ?></h5>
                            <div class="avatar--lg bg--purple">
                                <i class="bi bi-credit-card text-white"></i>
                            </div>
                        </div>

                        <div class="card-info text-center">
                            <ul class="user-card-list w-100">
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.investment.total')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->total)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.investment.profit')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->profit)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.investment.running')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->running)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold"><?php echo e(__('frontend.dashboard.investment.re_invest')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->re_invest)); ?></span>
                                </li>
                                <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold"><?php echo e(__('frontend.dashboard.investment.closed')); ?></span>
                                    <span class="fw-bold text--dark"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentReport->closed)); ?></span>
                                </li>
                            </ul>
                            <a href="<?php echo e(route('user.investment.index')); ?>" class="btn--white"><?php echo e(__('frontend.dashboard.investment.now')); ?><i class="bi bi-box-arrow-up-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="i-card-sm">
                    <h5 class="title text--blue mb-4"><?php echo e(__('frontend.dashboard.deposit_withdraw.monthly_report')); ?></h5>
                    <div id="investProfitChart"></div>
                </div>
            </div>
        </div>

        <?php if($investmentPlans->isNotEmpty()): ?>
            <div class="i-card-sm mb-4">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="swiper plan-card-slider">
                            <div class="swiper-wrapper">
                                <?php $__currentLoopData = $investmentPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investmentPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="card card--design ">
                                            <div class="card-body">
                                                <div class="row align-items-end g-3">
                                                    <div class="col-8">
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar--sm">
                                                                <i class="las la-list-alt fs-24 text--primary"></i>
                                                            </div>
                                                            <h6 class="ms-2 mb-0 fs-14 text--primary"><?php echo e(__($investmentPlan->name)); ?></h6>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 text-start">
                                                        <p class="fs-13 fw-normal text--light"><?php echo e(__('admin.dashboard.content.invest.total_one')); ?></p>
                                                        <h6 class="fs-16"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentPlan->investmentLogs->sum('amount'))); ?></h6>
                                                    </div>
                                                    <div class="col-6 text-end">
                                                        <p class="fs-13 fw-normal text--light"><?php echo e(__('admin.dashboard.content.invest.profit')); ?></p>
                                                        <h6 class="fs-16"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($investmentPlan->investmentLogs->sum('profit'))); ?></h6>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm">
                    <div class="card-header">
                        <h4 class="title"><?php echo e(__($setTitle)); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo $__env->make('user.partials.matrix.commission', [
                                    'commissions' => $profitLogs,
                                    'type' => \App\Enums\CommissionType::INVESTMENT->value,
                                    'route' => route('user.investment.profit.statistics'),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-4"><?php echo e($profitLogs->links()); ?></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            const currency = "<?php echo e(getCurrencySymbol()); ?>";
            const invest = <?php echo json_encode($invest, 15, 512) ?>;
            const profit = <?php echo json_encode($profit, 15, 512) ?>;
            const months = <?php echo json_encode($months, 15, 512) ?>;

            const investmentOptions = {
                series: [{
                    name: 'Profit',
                    data: profit
                }, {
                    name: 'Invest',
                    data: invest
                }],
                chart: {
                    height: 255,
                    type: 'area'
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth'
                },
                xaxis: {
                    type: 'date',
                    categories: months
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return currency + val
                        }
                    }
                }
            };

            const investmentProfit = new ApexCharts(document.querySelector("#investProfitChart"), investmentOptions);
            investmentProfit.render();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/investment/profit.blade.php ENDPATH**/ ?>