<?php $__env->startSection('panel'); ?>
    <section>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__($setTitle)); ?></h4>
                <button id="add-kyc-setting-option" class="i-btn btn--primary btn--md">
                    <i class="las la-plus me-1"></i><?php echo e(__('Add More')); ?>

                </button>
            </div>

            <div class="card-body">
                <form action="<?php echo e(route('admin.general.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="type" value="<?php echo e(\App\Enums\GeneralSetting::KYC_CONFIGURATION->value); ?>">
                    <div class="table-container verification-table">
                        <table class="align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th><?php echo e(__('Labels')); ?></th>
                                    <th><?php echo e(__('Type')); ?></th>
                                    <th><?php echo e(__('Required')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody id="ticketField">
                            <?php $__currentLoopData = $setting->kyc_configuration; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make('admin.partials.kyc_option_row', ['key' => $key, 'value' => $value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <button class="i-btn btn--primary btn--lg mt-4"><?php echo e(__('Submit')); ?></button>
                </form>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            let count = <?php echo e(count($setting->kyc_configuration) - 1); ?>;

            function createKycOptionRow(count) {
                return `<?php echo $__env->make('admin.partials.kyc_option_row', ['key' => '${count}', 'value' => null], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;
            }

            $(document).on('click', '#add-kyc-setting-option', function (e) {
                count++;
                const html = createKycOptionRow(count);
                $('#ticketField').append(html);
                e.preventDefault();
            });

            $(document).on('click', '.delete-key-setting-option', function (e) {
                $(this).closest("tr").remove();
                count--;
                e.preventDefault();
            });

            // Handle dropdown type change
            $(document).on('change', '.type-dropdown', function () {
                const selectedType = $(this).val();
                const isButtonRequired = ['select', 'checkbox', 'radio'].includes(selectedType);
                const optionsHtml = isButtonRequired ? '<button class="add-dropdown-options btn btn--primary btn--sm mb-3"><?php echo e(__("Add")); ?></button>' : '';
                $(this).closest('td').find('.add-options').html(optionsHtml);
            });

            // Add options for dropdown type
            $(document).on('click', '.add-options', function (e) {
                const html = addDropdownOptions(count);
                $(this).siblings('.optionsFiled').append(html);
                e.preventDefault();
            });

            function addDropdownOptions(count) {
                return '<div class="dropdown-option d-flex justify-content-end mb-2">' +
                    '<input type="text" class="form-control rounded-end-0" name="kyc_configuration[' + count + '][options][]" value="">' +
                    '<a href="#" class="remove-dropdown-option btn btn--danger btn--sm rounded-end rounded-start-0"><i class="bi bi-x-lg"></i></a>' +
                    '</div>';
            }

            // Remove dropdown option
            $(document).on('click', '.remove-dropdown-option', function (e) {
                $(this).closest('.dropdown-option').remove();
                e.preventDefault();
            });
        });
    </script>

<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/setting/kyc.blade.php ENDPATH**/ ?>