@extends('layouts.user')
@section('content')

<div class="main-content" data-simplebar>
    <div class="i-card-sm mb-4 p-3">
        <!-- Small cards -->
        <div class="row">
            <div class="col-md-6">
                <ul class="d-flex flex-column gap-2">
                    <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Total Prize Pool</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ getCurrencySymbol() }} {{ number_format($totalPrizePool, 0) }}</h5>
                        </div>
                    </li>
                     <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Total Rewards Distributed</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ getCurrencySymbol() }} {{ number_format($totalRewardsDistributed, 0) }}</h5>
                        </div>
                    </li>
                    <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Total Competitions</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ $totalCompetitions }}</h5>
                        </div>
                    </li>
                   
                    <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Running Competitions</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ $runningCompetitions }}</h5>
                        </div>
                    </li>
                    <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Live Competitions</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ $liveCompetitions }}</h5>
                        </div>
                    </li>
                    <li class="p-3 d-flex bg--light">
                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                            <h5 class="text--light fs-14">Competitions Participated</h5>
                        </div>
                        <div class="flex-shrink-0 text-end">
                            <h5 class="text--dark fw-bold fs-14" style="color: var(--color-primary);">{{ $completedCompetitions }}</h5>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-md-6">
                <div class="i-card-sm primary--light shadow-none flex-grow-1 py-3 px-4 rounded-3 mb-3">
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-trophy" style="font-size: 24px;"></i>
                        <div>
                            <span class="inline-block lh-1">Participated</span>
                            <h5 class="mt-2" style="color: var(--color-primary);">{{ $competitionsParticipated }}</h5>
                        </div>
                    </div>
                </div>
                
                {{--   
                <div class="i-card-sm primary--light shadow-none flex-grow-1 py-3 px-4 rounded-3">
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-trophy" style="font-size: 24px;"></i>
                        <div>
                            <span class="inline-block lh-1">Total Rewards Won</span>
                            <h5 class="mt-2" style="color: var(--color-primary);">{{ getCurrencySymbol() }} {{ number_format($myRewardsWon, 0) }}</h5>
                        </div>
                    </div>
                </div>
                
                --}}
                
                
                
                <div class="i-card-sm primary--light shadow-none flex-grow-1 py-3 px-4 rounded-3">
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-trophy" style="font-size: 24px;"></i>
                        <div>
                            <span class="inline-block lh-1">Total Rewards Won</span>
                            <h5 class="mt-2" style="color: var(--color-primary);">{{ getCurrencySymbol() }}</h5> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>









    
		<div class="i-card-sm mb-4 p-3">
			<ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
				<li class="nav-item" role="presentation">
					<button class="nav-link active" id="live-competition-tab" data-bs-toggle="pill" data-bs-target="#live-competition" type="button" role="tab" aria-controls="live-competition" aria-selected="true">Live Competition</button>
				</li>
				<li class="nav-item" role="presentation">
					<button class="nav-link" id="upcoming-competition-tab" data-bs-toggle="pill" data-bs-target="#upcoming-competition" type="button" role="tab" aria-controls="upcoming-competition" aria-selected="false">Upcoming Competition</button>
				</li>
				<li class="nav-item" role="presentation">
					<button class="nav-link" id="past-competition-tab" data-bs-toggle="pill" data-bs-target="#past-competition" type="button" role="tab" aria-controls="past-competition" aria-selected="false">Past Competition</button>
				</li>
				<li class="nav-item" role="presentation">
					<button class="nav-link" id="my-competition-tab" data-bs-toggle="pill" data-bs-target="#my-competition" type="button" role="tab" aria-controls="my-competition" aria-selected="false">My Competition</button>
				</li>
			</ul>			
				
        </div>
        <div class="i-card-sm mb-4">
			<div class="tab-content" id="pills-tabContent">	
				<div class="tab-pane fade show active" id="live-competition" role="tabpanel" aria-labelledby="live-competition-tab">
					<div class="row g-3e">
						@if(count($liveCompetition) > 0)
						@foreach($liveCompetition as $livecompetitionVal)
						<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-2">
							<div class="i-card-sm primary--light shadow-none rounded-3">
								<div class="row justify-content-between align-items-center g-lg-2 g-1">
									<div class="col-12">
										<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3 gap-3">
											<h5 class="title-sm mb-0">{{ $livecompetitionVal->title }}</h5>
										</div>
									</div>
								</div>
								<div class="card-info text-center">
									<ul class="user-card-list w-100">
										@php
											$dateString = $livecompetitionVal->end_time;
											$endDate = \Carbon\Carbon::parse($dateString);
											$now = \Carbon\Carbon::now();
											$diff = $endDate->diff($now);
											$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Ends In') }}</span>
											<span class="fw-bold text--dark">{{ $duration }}</span>
										</li>
										@php
											$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $livecompetitionVal->start_time);
											$startTime = $startTime->format('F, j (H:i)');
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Started At') }}</span>
											<span class="fw-bold text--dark">{{ $startTime }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Prize Pool') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($livecompetitionVal->prize_pool_amt, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Entry Fee') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($livecompetitionVal->entry_fee, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Participants') }}</span>
											<span class="fw-bold text--dark">{{ count($livecompetitionVal->participants) }}/{{ $livecompetitionVal->number_of_participants }}</span>
										</li>
									</ul>
									<div class="d-flex justify-content-between align-items-center">
										<a href="{{ route('user.competition.competition-details', $livecompetitionVal->id) }}"><button class="i-btn btn--white btn--sm border-radius-5px">{{ __('View  Details') }}</button></a>
										@if($livecompetitionVal->number_of_participants > count($livecompetitionVal->participants))
											@if(!in_array(\Auth::id(), $livecompetitionVal->participants->pluck('user_id')->toArray()))	
												<button class="i-btn btn--primary btn--sm joinCompetition" data-id="{{ $livecompetitionVal->id }}">{{ __('Participate Now') }}</button>
											@else
												<button class="i-btn btn--primary btn--sm">{{ __('Participated') }}</button>
											@endif
										@endif
									</div>
								</div>
							</div>
						</div>
						@endforeach
						@else
							<div class="text-center">No Record Found</div>
						@endif
					</div>
				</div>
				<div class="tab-pane fade" id="upcoming-competition" role="tabpanel" aria-labelledby="upcoming-competition-tab">
					<div class="row g-3e">
						@if(count($upcomingCompetition) > 0)
						@foreach($upcomingCompetition as $upcomingCompetitionVal)
						<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-2">
							<div class="i-card-sm primary--light shadow-none rounded-3">
								<div class="row justify-content-between align-items-center g-lg-2 g-1">
									<div class="col-12">
										<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3 gap-3">
											<h5 class="title-sm mb-0">{{ $upcomingCompetitionVal->title }}</h5>
										</div>
									</div>
								</div>
								<div class="card-info text-center">
									<ul class="user-card-list w-100">
										@php
											$dateString = $upcomingCompetitionVal->end_time;
											$endDate = \Carbon\Carbon::parse($dateString);
											$now = \Carbon\Carbon::now();
											$diff = $endDate->diff($now);
											$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Ends In') }}</span>
											<span class="fw-bold text--dark">{{ $duration }}</span>
										</li>
										@php
											$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $upcomingCompetitionVal->start_time);
											$startTime = $startTime->format('F, j (H:i)');
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Started At') }}</span>
											<span class="fw-bold text--dark">{{ $startTime }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Prize Pool') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($upcomingCompetitionVal->prize_pool_amt, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Entry Fee') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($upcomingCompetitionVal->entry_fee, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Participants') }}</span>
											<span class="fw-bold text--dark">{{ count($upcomingCompetitionVal->participants) }}/{{ $upcomingCompetitionVal->number_of_participants }}</span>
										</li>
									</ul>
									<div class="d-flex justify-content-between align-items-center">
										<a href="{{ route('user.competition.competition-details', $upcomingCompetitionVal->id) }}"><button class="i-btn btn--white btn--sm border-radius-5px">{{ __('View  Details') }}</button></a>
									</div>
								</div>
							</div>
						</div>
						@endforeach
						@else
							<div class="text-center">No Record Found</div>
						@endif
					</div>
				</div>
				<div class="tab-pane fade" id="past-competition" role="tabpanel" aria-labelledby="past-competition-tab">
					<div class="row g-3e">
						@if(count($pastCompetition) > 0)
						@foreach($pastCompetition as $pastCompetitionVal)
						<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-2">
							<div class="i-card-sm primary--light shadow-none rounded-3">
								<div class="row justify-content-between align-items-center g-lg-2 g-1">
									<div class="col-12">
										<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3 gap-3">
											<h5 class="title-sm mb-0">{{ $pastCompetitionVal->title }}</h5>
										</div>
									</div>
								</div>
								<div class="card-info text-center">
									<ul class="user-card-list w-100">
										@php
											$dateString = $pastCompetitionVal->end_time;
											$endDate = \Carbon\Carbon::parse($dateString);
											$now = \Carbon\Carbon::now();
											$diff = $endDate->diff($now);
											$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Ends In') }}</span>
											<span class="fw-bold text--dark">{{ $duration }}</span>
										</li>
										@php
											$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $pastCompetitionVal->start_time);
											$startTime = $startTime->format('F, j (H:i)');
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Started At') }}</span>
											<span class="fw-bold text--dark">{{ $startTime }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Prize Pool') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($pastCompetitionVal->prize_pool_amt, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Entry Fee') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($pastCompetitionVal->entry_fee, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Participants') }}</span>
											<span class="fw-bold text--dark">{{ count($pastCompetitionVal->participants) }}/{{ $pastCompetitionVal->number_of_participants }}</span>
										</li>
									</ul>
									<div class="d-flex justify-content-between align-items-center">
										<a href="{{ route('user.competition.competition-details', $pastCompetitionVal->id) }}"><button class="i-btn btn--white btn--sm border-radius-5px">{{ __('View  Details') }}</button></a>
									</div>
								</div>
							</div>
						</div>
						@endforeach
						@else
							<div class="text-center">No Record Found</div>
						@endif
					</div>
				</div>
				<div class="tab-pane fade" id="my-competition" role="tabpanel" aria-labelledby="my-competition-tab">
					<div class="row g-3e">
						@if(count($myCompetition) > 0)
						@foreach($myCompetition as $myCompetitionVal)
						<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-2">
							<div class="i-card-sm primary--light shadow-none rounded-3">
								<div class="row justify-content-between align-items-center g-lg-2 g-1">
									<div class="col-12">
										<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3 gap-3">
											<h5 class="title-sm mb-0">{{ $myCompetitionVal->title }}</h5>
										</div>
									</div>
								</div>
								<div class="card-info text-center">
									<ul class="user-card-list w-100">
										@php
											$dateString = $myCompetitionVal->end_time;
											$endDate = \Carbon\Carbon::parse($dateString);
											$now = \Carbon\Carbon::now();
											$diff = $endDate->diff($now);
											$duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Ends In') }}</span>
											<span class="fw-bold text--dark">{{ $duration }}</span>
										</li>
										@php
											$startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $myCompetitionVal->start_time);
											$startTime = $startTime->format('F, j (H:i)');
										@endphp
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Started At') }}</span>
											<span class="fw-bold text--dark">{{ $startTime }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Prize Pool') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($myCompetitionVal->prize_pool_amt, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Entry Fee') }}</span>
											<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($myCompetitionVal->entry_fee, 0) }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Participants') }}</span>
											<span class="fw-bold text--dark">{{ count($myCompetitionVal->participants) }}/{{ $myCompetitionVal->number_of_participants }}</span>
										</li>
									</ul>
									<div class="d-flex justify-content-between align-items-center">
										<a href="{{ route('user.competition.competition-details', $myCompetitionVal->id) }}"><button class="i-btn btn--white btn--sm border-radius-5px">{{ __('View  Details') }}</button></a>
										@if($myCompetitionVal->number_of_participants > count($myCompetitionVal->participants))
											@if(!in_array(\Auth::id(), $myCompetitionVal->participants->pluck('user_id')->toArray()))	
												<button class="i-btn btn--primary btn--sm joinCompetition" data-id="{{ $myCompetitionVal->id }}">{{ __('Participate Now') }}</button>
											@else
												<button class="i-btn btn--primary btn--sm">{{ __('Participated') }}</button>
											@endif
										@endif
									</div>
								</div>
							</div>
						</div>
						@endforeach
						@else
							<div class="text-center">No Record Found</div>
						@endif
					</div>
				</div>
			</div>
		</div>
    </div>
	<div class="modal" id="joinCompetitionModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header primary--light border-0">
					<h5 class="modal-title" id="competitionTitle"> </h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>				
				<div class="modal-body">
					<ul class="user-card-list w-100">
						<li class="d-flex align-items-center justify-content-between gap-3">
							<input type="hidden" id="modal-competition-id">
							<span class="fw-bold">{{ __('Entry Fee') }}</span>
							<span class="fw-bold text--dark">{{ getCurrencySymbol() }} <span id="entryAmount"></span></span>
						</li>
					</ul>
				</div>
				<div class="modal-footer">
					<button type="button" class="i-btn btn--white btn--sm" data-bs-dismiss="modal" aria-label="Close">Close</button>
					<button type="button" class="i-btn btn--primary btn--sm" id="joinCompetition">Participate</button>
				</div>
			</div>
		</div>
	</div>
@endsection

@push('script-push')
<script>
$(document).on("click", "#joinCompetition", function() {
	var competition_id = $('#modal-competition-id').val();
	$.ajax({
		headers: {
			"X-CSRF-TOKEN": "{{ csrf_token() }}",
		},
		url: "{{ route('user.competition.join-competition') }}",
		method: "POST",
		data: {
			competition_id: competition_id
		},
		success: function(response) {
			if(response.status == 200){
				notify('success', response.success);
				window.location.replace(response.redirect_route);
			}else{
				notify('error', response.error);
			}			
		},
		error: function(response) {
			const errorMessage = response.responseJSON ? response.responseJSON.error : "An error occurred.";
			notify('error', errorMessage);
		}
	});
});
$(document).on("click", ".joinCompetition", function() {
	var competition_id = $(this).data('id');
	$.ajax({
		headers: {
			"X-CSRF-TOKEN": "{{ csrf_token() }}",
		},
		url: "{{ route('user.competition.competition-details-availability') }}",
		method: "POST",
		data: {
			competition_id: competition_id
		},
		success: function(response) {
			if(response.status == 200){
				$('#competitionTitle').text(response.data.title);
				$('#entryAmount').text(response.data.entry_fee);
				$('#modal-competition-id').val(response.data.id);
				$('#joinCompetitionModal').modal('show');
				//notify('success', response.success);
			}else{
				notify('error', response.error);
			}			
		},
		error: function(response) {
			const errorMessage = response.responseJSON ? response.responseJSON.error : "An error occurred.";
			notify('error', errorMessage);
		}
	});
});
</script>
@endpush
