<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MatrixInvestmentDetails extends Model
{
    use HasFactory;
	
	protected $table = 'matrix_investments_details';
	
    protected $fillable = [
        'matrix_investments_id',
        'franchaisee_id',
        'pin_amount',
        'franchaisee_commission_amount'
    ];

    public function matrix_invest()
    {
        return $this->hasOne(MatrixInvestment::class, 'id', 'matrix_investments_id');
    }
}
