<?php

namespace App\Enums;

enum Franchisee: int
{
    use EnumTrait;

    case FRANCHISEE_USER = 1;
    case REGULAR_USER = 2;

    public static function getColor(int $franchisee): string {
        return match($franchisee) {
            self::FRANCHISEE_USER->value => 'badge--success',
            self::REGULAR_USER->value => 'badge--danger',
            default => 'black'
        };
    }

    public static function getName(int $franchisee, bool $is_bool = false): string {
        return match ($franchisee) {
            self::FRANCHISEE_USER->value => $is_bool ? 'Yes' : 'Active',
            self::REGULAR_USER->value => $is_bool ? 'No' : 'Inactive',
            default => 'Default'
        };
    }


}
