<?php $__env->startSection('panel'); ?>
   <section>
       <div class="card">
           <div class="card-header">
               <h4 class="card-title"><?php echo e(__($setTitle)); ?></h4>
           </div>
           <div class="card-body">
               <ol class="list-group list-group-numbered">
                   <?php $__currentLoopData = getArrayValue($applicationInfo, 'application'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $filePath): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <li class="list-group-item d-flex justify-content-between align-items-start">
                           <div class="ms-2 me-auto text--dark"><?php echo e(replaceInputTitle($key)); ?></div>
                           <span><?php echo e($filePath); ?></span>
                       </li>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                   <li class="list-group-item d-flex justify-content-between align-items-start">
                       <div class="ms-2 me-auto text--dark"><?php echo app('translator')->get('Document Root Folder'); ?> </div>
                       <span><?php echo e($server_detail['DOCUMENT_ROOT']); ?></span>
                   </li>
                   <li class="list-group-item d-flex justify-content-between align-items-start">
                       <div class="ms-2 me-auto text--dark"><?php echo app('translator')->get('PHP Version'); ?></div>
                       <span><?php echo e(phpversion()); ?></span>
                   </li>
                   <li class="list-group-item d-flex justify-content-between align-items-start">
                       <div class="ms-2 me-auto text--dark"><?php echo app('translator')->get('Laravel Version'); ?></div>
                       <span><?php echo e(app()->version()); ?></span>
                   </li>
                   <li class="list-group-item d-flex justify-content-between align-items-start">
                       <div class="ms-2 me-auto text--dark"><?php echo app('translator')->get('IP Address'); ?></div>
                       <span><?php echo e($server_detail['REMOTE_ADDR'] ?? ''); ?></span>
                   </li>
                   <li class="list-group-item d-flex justify-content-between align-items-start">
                       <div class="ms-2 me-auto text--dark"><?php echo app('translator')->get('Server Host'); ?></div>
                       <span><?php echo e($server_detail['HTTP_HOST']); ?></span>
                   </li>
               </ol>
           </div>
       </div>

       <div class="card mt-3">
           <div class="card-header">
               <h4 class="card-title"><?php echo e(__('PHP Extension Access Management')); ?></h4>
           </div>
           <div class="card-body">
               <ol class="list-group list-group-numbered">
                   <?php $__currentLoopData = getArrayValue($applicationInfo, 'requirements.php'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $filePath): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <li class="list-group-item d-flex justify-content-between align-items-start">
                           <div class="ms-2 me-auto text--dark"><?php echo e($filePath); ?></div>
                           <span>
                               <?php if(is_writable(base_path($filePath))): ?>
                                   <i class="las la-check text--success"></i>
                               <?php else: ?>
                                   <i class="las la-times text--danger"></i>
                               <?php endif; ?>
                           </span>
                       </li>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </ol>
           </div>
       </div>

       <div class="card mb-3 mt-3">
           <div class="card-header">
               <h6  class="card-title"><?php echo e(__('Access Control for Files and Folders')); ?></h6>
           </div>
           <div class="responsive-table">
                <table>
                    <thead>
                        <tr>
                            <th><?php echo e(__('Files and Folders')); ?></th>
                            <th><?php echo e(__('Permissions')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = getArrayValue($applicationInfo, 'permissions'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $filePath): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key); ?></td>
                                <td><?php echo e($filePath); ?></td>
                                <td>
                                    <?php if(is_writable(base_path($filePath))): ?>
                                        <i class="las la-check text--success"></i>
                                    <?php else: ?>
                                        <i class="las la-times text--danger"></i>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
       </div>
   </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/admin/setting/system.blade.php ENDPATH**/ ?>