<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
         <div class="row">
            <div class="col-6">
                <div class="i-card-sm mb-4 p-3">
                    <label for="referral-url" class="form-label">Referral URL</label>
                    <div class="input-group">
                        <input type="text" id="referral-url" class="form-control reference-url" value="<?php echo e(route('home', ['reference' => \Illuminate\Support\Facades\Auth::user()->uuid])); ?>" aria-label="Recipient's username" aria-describedby="reference-copy" readonly>
                        <span class="input-group-text bg--primary text-white" id="reference-copy"><?php echo e(__('Copy')); ?><i class="las la-copy ms-2"></i></span>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="i-card-sm mb-4 p-3">
                    <label for="user-uid" class="form-label">UID</label>
                    <div class="input-group">
                        <input type="text" id="user-uid" class="form-control user-uid" value="<?php echo e(\Illuminate\Support\Facades\Auth::user()->uuid); ?>" aria-label="Recipient's username" aria-describedby="user-uid-copy" readonly>
                        <span class="input-group-text bg--primary text-white" id="user-uid-copy"><?php echo e(__('Copy')); ?><i class="las la-copy ms-2"></i></span>
                    </div>
                </div>
            </div>
        </div>
      
        <div class="i-card-sm mb-4">
            <div class="row g-4">
                
               <!-- New KYC Status Card -->
                <div class="col-12">
                    <div class="i-card-sm card-style purple rounded-3">
                        
                        <div class="card-info text-center">
                            <div class="row">
                                <!-- KYC Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->kyc_status == 1 ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('KYC Status')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->kyc_status == 1 ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->kyc_status == 1 ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                </div>
                                <!-- Email Verification Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->email_verified_at ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('Email')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->email_verified_at ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->email_verified_at ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                    <?php if($user->email_verified_at): ?>
                                        <span class="text-muted ms-2">(<?php echo e($user->email_verified_at); ?>)</span>
                                    <?php endif; ?>
                                </div>
                                <!-- Phone Verification Status -->
                                <div class="col-md-4 text-center mb-2">
                                    <i class="bi <?php echo e($user->phone_verified_at ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'); ?> me-2"></i>
                                    <span class="fw-bold"><?php echo e(__('Mobile')); ?>: </span>
                                    <span class="fw-bold text-<?php echo e($user->phone_verified_at ? 'success' : 'danger'); ?>">
                                        <?php echo e($user->phone_verified_at ? __('Verified') : __('Not Verified')); ?>

                                    </span>
                                    <?php if($user->phone_verified_at): ?>
                                        <span class="text-muted ms-2">(<?php echo e($user->phone_verified_at); ?>)</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of New KYC Status Card -->
                
                
                 <div class="row g-4 mb-4">
    <div class="col-lg-6">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm green">
                <div class="card-info">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5 class="title"><?php echo e(__('Rewards')); ?></h5>
                        <a class="arrow--btn" href="<?php echo e(route('user.referral.index')); ?>"><?php echo e(__('Referral Rewards')); ?> <i class="bi bi-arrow-right-short"></i></a>
                    </div>
                     <div class="total-balance-wrapper">
                         
                        
                        
                    <div class="total-balance">
                        <p><?php echo e(__('Buddy Rewards')); ?></p>
                        <div class="d-flex gap-2">
                            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(getArrayValue($commissions, 'referral'))); ?></h4>
                        </div>
                        
                    </div>
                    <div class="total-balance">
                        <p><?php echo e(__('Stage Referrals')); ?></p>
                        <div class="d-flex gap-2">
                            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(getArrayValue($commissions, 'level'))); ?></h4>
                        </div>
                    </div>
                    <div class="total-balance">
                        <p><?php echo e(__('Competetion Rewards')); ?></p>
                        <div class="d-flex gap-2">
                           <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount((Auth::user()?->wallet->reward_balance)) - (getArrayValue($commissions, 'referral'))-(getArrayValue($commissions, 'level'))); ?></h4>
                        </div>
                    </div>
  
  
<?php if(Auth::user()->is_franchisee): ?>
    <div class="total-balance">
        <p><?php echo e(__('Total Franchisee Commission')); ?></p>
        <div class="d-flex gap-2">
            <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($totalFranchiseeCommission)); ?></h4>
        </div>
    </div>
<?php endif; ?>



                </div>
            </div>
        </div>
    </div>
    </div>

    <div class="col-lg-6">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm pink">
                <div class="card-info">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <h5 class="title"><?php echo e(__('Balance')); ?></h5>
                        <a class="arrow--btn" href="<?php echo e(route('user.wallet.index')); ?>"><?php echo e(__('Balance Transfer')); ?> <i class="bi bi-arrow-right-short"></i></a> 
                    </div>
                    <div class="total-balance-wrapper">
                        <div class="total-balance">
                            <p><?php echo e(__('Primary Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->primary_balance)); ?></h4>
                            </div>
                        </div>
                        
                        
                        <div class="total-balance">
                            <p><?php echo e(__('Trade Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->trade_balance)); ?></h4>
                            </div>
                        </div>
                        <div class="total-balance">
                            <p><?php echo e(__('Virtual Trade Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->virtual_trade_balance)); ?></h4>
                            </div>
                        </div>
                        
                        
                        <div class="total-balance">
                            <p><?php echo e(__('Referral & Reward Balance')); ?></p>
                            <div class="d-flex gap-2">
                                <h4><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()?->wallet->reward_balance)); ?></h4>
                            </div>
                        </div>
                        
                        
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(Auth::user()->is_franchisee): ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="i-card-sm">
                <div class="card-header">
                    <h4 class="title"><?php echo e(__("Franchisee Commission Details")); ?></h4>
                </div>
                <?php echo $__env->make('user.partials.commission', ['commission_details' => $commission_details, 'is_paginate' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>



        </div>
    </div>
<?php $__env->stopSection(); ?>







<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            const depositMonthAmount = <?php echo json_encode($depositMonthAmount, 15, 512) ?>;
            const withdrawMonthAmount = <?php echo json_encode($withdrawMonthAmount, 15, 512) ?>;
            const months = <?php echo json_encode($months, 15, 512) ?>;
            const currency = "<?php echo e(getCurrencySymbol()); ?>";

            const options = {
                series: [
                    {
                        name: 'Total Deposits Amount',
                        data: depositMonthAmount
                    },
                    {
                        name: 'Total Withdraw Amount',
                        data: withdrawMonthAmount
                    }
                ],
                chart: {
                    height: 530,
                    type: 'line',
                    toolbar: false,
                    zoom: {
                        enabled: false
                    }
                },
                plotOptions: {
                    bar: {
                        borderRadius: 10,
                        dataLabels: {
                            position: 'bottom',
                        },
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function (val, opts) {
                        return '';
                    },
                    offsetY: -20,
                    style: {
                        fontSize: '12px',
                        colors: ["#304758"]
                    }
                },
                xaxis: {
                    categories: months,
                    position: 'top',
                    axisBorder: {
                        show: false
                    },
                    axisTicks: {
                        show: false
                    },
                    crosshairs: {
                        fill: {
                            type: 'gradient',
                            gradient: {
                                colorFrom: '#D8E3F0',
                                colorTo: '#BED1E6',
                                stops: [0, 100],
                                opacityFrom: 0.4,
                                opacityTo: 0.5,
                            }
                        }
                    },
                    tooltip: {
                        enabled: true,
                    }
                },
                yaxis: {
                    axisBorder: {
                        show: false
                    },
                    axisTicks: {
                        show: false,
                    },
                    labels: {
                        show: false,
                        formatter: function (val) {
                            return currency + val;
                        }
                    }
                },
                title: {
                    floating: true,
                    offsetY: 340,
                    align: 'center',
                    style: {
                        color: '#222',
                        fontWeight: 600
                    }
                }
            };

            const chart = new ApexCharts(document.querySelector("#monthlyChart"), options);
            chart.render();

            $('#reference-copy').click(function() {
                const copyText = $('.reference-url');
                copyText.select();
                document.execCommand('copy');
                copyText.blur();
                notify('success', 'Copied to clipboard!');
            });


            $('#user-uid-copy').click(function() {
                const copyTextUID = $('.user-uid');
                copyTextUID.select();
                document.execCommand('copy');
                copyTextUID.blur();
                notify('success', 'Copied to clipboard!');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lltrusti/demo.cryptra.markets/src/resources/views/user/dashboard.blade.php ENDPATH**/ ?>