<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Auth\FacebookAuthenticatedController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\PasswordController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\GoogleAuthenticatedController;
use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\PhoneVerificationController;


Route::middleware(['guest', 'firewall.all'])->group(function () {
    Route::get('register', [RegisteredUserController::class, 'create'])->name('register');
    Route::post('register', [RegisteredUserController::class, 'store']);
    Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');
    Route::post('login', [AuthenticatedSessionController::class, 'store']);
    Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])->name('password.request');
    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])->name('password.email');
    Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset');
    Route::post('reset-password', [NewPasswordController::class, 'store'])->name('password.store');
    Route::get('register-as-a-franchisee', [RegisteredUserController::class, 'createfranchisee'])->name('register-as-a-franchisee');
    Route::post('register-as-a-franchisee', [RegisteredUserController::class, 'storefranchisee']);


    //Google
    Route::get('google/', [GoogleAuthenticatedController::class, 'redirectToGoogle'])->name('google.login');
    Route::get('google/callback', [GoogleAuthenticatedController::class, 'handleGoogleCallback']);

    //Facebook
    Route::get('facebook/', [FacebookAuthenticatedController::class, 'redirectToFacebook'])->name('facebook.login');
    Route::get('facebook/callback', [FacebookAuthenticatedController::class, 'handleFacebookCallback']);
});

Route::middleware(['auth', 'firewall.all'])->group(function () {
    Route::get('verify-email', EmailVerificationPromptController::class)->name('verification.notice');
    Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)->middleware(['signed', 'throttle:6,1'])->name('verification.verify');
    Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])->middleware('throttle:6,1')->name('verification.send');
    Route::get('phone/verify', [PhoneVerificationController::class, 'show'])->name('phoneverification.notice');
    Route::post('phone/verify', [PhoneVerificationController::class, 'verify'])->name('phoneverification.verify');
    Route::post('phone/code-send', [PhoneVerificationController::class, 'resend'])->name('phoneverification.send');


    Route::get('confirm-password', [ConfirmablePasswordController::class, 'show'])->name('password.confirm');
    Route::post('confirm-password', [ConfirmablePasswordController::class, 'store']);
    Route::put('password', [PasswordController::class, 'update'])->name('password.update');
    Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');
});
