<div class="card-body">
    <div class="row align-items-center gy-4 mb-3">
        <div class="table-container">
            <table id="myTable" class="table">
                <thead>
                    <tr>
                        <th scope="col">{{ __('Joined At') }}</th>
                        <th scope="col">{{ __('Subscription Name') }}</th>
                        <th scope="col">{{ __('Subscription Price') }}</th>
                        <th scope="col">{{ __('Subscription User') }}</th>
                        <th scope="col">{{ __('Subscription Code') }}</th>
                        <th scope="col">{{ __('Commission Amount') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($commission_details as $key => $item)
                        <tr>
                            <td data-label="{{ __('Joined At') }}">{{ showDateTime($item->created_at) }}</td>
                            <td data-label="{{ __('Subscrition Name') }}">
                                @if ($item->matrix_invest)
                                    {{ $item->matrix_invest->name }}
                                @else
                                    {{ __('N/A') }}
                                @endif
                            </td>
                            <td data-label="{{ __('Subscrition Price') }}">
                                @if ($item->matrix_invest)
                                    {{ shortAmount($item->matrix_invest->price) }}
                                @else
                                    {{ __('N/A') }}
                                @endif
                            </td>
                            <td data-label="{{ __('Subscrition User') }}">
                                @if ($item->matrix_invest && $item->matrix_invest->user)
                                    {{ $item->matrix_invest->user->first_name }}
                                @else
                                    {{ __('N/A') }}
                                @endif
                            </td>
                            <td data-label="{{ __('Subscrition Code') }}">
                                @if ($item->matrix_invest)
                                    {{ $item->matrix_invest->pin_number }}
                                @else
                                    {{ __('N/A') }}
                                @endif
                            </td>
                            <td data-label="{{ __('Commission Amount') }}">
                                {{ shortAmount($item->franchaisee_commission_amount) }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@if($is_paginate)
    <div class="mt-4">{{ $commission_details->links() }}</div>
@endif
