@extends('layouts.user')
@section('content')
    <div class="main-content" data-simplebar>
		<div class="i-card-sm mb-4 p-3">
			<div class="row g-3e">
				<div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12">
					<div class="i-card-sm yellow rounded-3">
						<div class="row justify-content-between align-items-center g-lg-2 g-1">
							<div class="col-12">
								<div class="d-flex align-items-center justify-content-between border-bottom pb-3 mb-3 gap-3">
									<h5 class="title-sm mb-0">{{ $competition_details->title }}</h5>
									<button class="i-btn btn--white btn--sm border-radius-5px competitionRules">{{ __('Contest Rules') }}</button>
								</div>
							</div>
						</div>
						<div class="card-info text-center">
							<ul class="user-card-list w-100 mb-0">
								<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Prize Pool') }}</span>
									<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($competition_details->prize_pool_amt, 0) }}</span>
								</li>
								<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Entry Fee') }}</span>
									<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($competition_details->entry_fee, 0) }}</span>
								</li>
								<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Virtual Trade Amount') }}</span>
									<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($competition_details->trade_amount, 0) }}</span>
								</li>
								<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Amount Per Virtual Trade') }}</span>
									<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($competition_details->per_trade_amount, 0) }}</span>
								</li>
								@if(in_array(\Auth::id(), $competition_details->participants->pluck('user_id')->toArray()))
								<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Existing Virtual Trade Wallet') }}</span>
									<span class="fw-bold text--dark">{{ getCurrencySymbol() }} {{ number_format($competition_details->participants->where('user_id', \Auth::id())->first()->competition_trade_amt, 0) }}</span>
								</li>
								@endif
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
<div class="row g-3e">		
    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-5">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm pink rounded-3">
                <div class="card-info text-center">
                    <ul class="user-card-list w-100 mb-0">
                        <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Participants') }}</span>
                            <span class="fw-bold text--dark">{{ count($competition_details->participants) }}/{{ $competition_details->number_of_participants }}</span>
                        </li>
                        @php
                            $dateString = $competition_details->end_time;
                            $endDate = \Carbon\Carbon::parse($dateString);
                            $now = \Carbon\Carbon::now();
                            $diff = $endDate->diff($now);
                            $duration = $diff->days . 'D : ' . $diff->h . 'H : ' . $diff->i . 'M : ' . $diff->s.'S';
                        @endphp
                        <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Ends In') }}</span>
                            @if($now > $competition_details->end_time)
                                <span class="fw-bold text--dark">{{ __('Expired') }}</span>
                            @else
                                <span class="fw-bold text--dark">{{ $duration }}</span>
                            @endif
                        </li>
                        @php
                            $startTime = \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $competition_details->start_time);
                            $startTime = $startTime->format('F, j (H:i)');
                        @endphp
                        <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Started At') }}</span>
                            <span class="fw-bold text--dark">{{ $startTime }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
	
   {{-- <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-5">
        <div class="i-card-sm mb-4 p-3">
            <div class="i-card-sm blue rounded-3">
                <div class="card-info text-center">
                    <ul class="user-card-list w-100 mb-0">
                        <!-- Trade Statistics details here -->
                        <li class="d-flex align-items-center justify-content-between gap-3">
                            <span class="fw-bold">{{ __('Total Trades') }}</span>
                            <span class="fw-bold text--dark">{{ $dummy_trade_statistics }}</span>
                        </li>
                        <li class="d-flex align-items-center justify-content-between gap-3">
                            <span class="fw-bold">{{ __('Total Amount') }}</span>
                            <span class="fw-bold text--dark">{{ $dummy_total_amount }}</span>
                        </li>
                        <li class="d-flex align-items-center justify-content-between gap-3">
                            <span class="fw-bold">{{ __('Profit/Loss') }}</span>
                            <span class="fw-bold text--dark">{{ $dummy_profit_loss }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div> --}}

@php
    $userId = auth()->user()->id;
    $userLeaderboardEntry = collect($leaderboard)->firstWhere('participant_id', $userId);
    $competitionStatus = $competition_details->status == 1 ? __('Completed') : __('Active');
    $reward_details = \App\Models\RewardRanking::where('participant_count', $competition_details->ranking_id)->first();
    $reward_total_amount = $competition_details->prize_pool_amt;
    $rankRewards = [];

    if ($reward_details) {
        $reward_details_rank = json_decode($reward_details->rank_value, true);
        foreach ($reward_details_rank as $data) {
            $from = (int) $data['rank_from'];
            $to = (int) $data['rank_to'];
            $percentage = (int) $data['percentage'];
            $rewardAmount = $reward_total_amount * ($percentage / 100);

            if ($from != $to) {
                $rankRewards[] = ['from' => $from, 'to' => $to, 'amount' => $rewardAmount];
            } else {
                $rankRewards[] = ['from' => $from, 'to' => $to, 'amount' => $rewardAmount];
            }
        }
    }
@endphp



<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-5">
    <div class="i-card-sm mb-4 p-3">
        <div class="i-card-sm pink rounded-3">
            <div class="card-info text-center">
                <ul class="user-card-list w-100 mb-0">
                   
                    
                    <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('My Current Rank') }}</span>
                        <span class="fw-bold text--dark">{{ $userLeaderboardEntry['rank'] ?? '-' }}</span>
                    </li>
                   {{-- <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Efficiency Ratio') }}</span>
                        <span class="fw-bold text--dark">{{ $userLeaderboardEntry['efficiency_ratio'] ?? '-' }}</span>
                    </li> --}}
                    <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('My Reward') }}</span>
                        <span class="fw-bold text--dark">
                            @if($competition_details->is_rewarded)
                                {{ getCurrencySymbol() }}{{ $userLeaderboardEntry['reward'] ?? '0' }}
                            @else
                                Running
                            @endif
                        </span>
                    </li>
                    <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Balance Virtual Trades') }}</span>
                        <span class="fw-bold text--dark">{{ $balanceTrades }}</span>
                    </li>
                    <li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Joined At') }}</span>
                        <span class="fw-bold text--dark">{{ \Carbon\Carbon::parse($joinedAt)->format('F j, Y H:i') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>



			<div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-7">
				<div class="i-card-sm yellow mb-4 p-3">
					<ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
						<li class="nav-item" role="presentation">
							<button class="nav-link active" id="leaderboard-tab" data-bs-toggle="pill" data-bs-target="#leaderboard" type="button" role="tab" aria-controls="leaderboard" aria-selected="true">Leaderboard</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link" id="participants-tab" data-bs-toggle="pill" data-bs-target="#participants" type="button" role="tab" aria-controls="participants" aria-selected="false">Participants</button>
						</li>
						<li class="nav-item" role="presentation">
							<button class="nav-link" id="virtual-trade-tab" data-bs-toggle="pill" data-bs-target="#virtual-trade" type="button" role="tab" aria-controls="virtual-trade" aria-selected="false">Virtual Trade Logs</button>
						</li>
					</ul>
					<div class="tab-content" id="pills-tabContent">	
						<div class="tab-pane fade show active trading" id="leaderboard" role="tabpanel" aria-labelledby="leaderboard-tab">
							<div class="trade-table scroll-design dark--table">
								<div class="table-container">
									<table>
										<thead>
											<tr>
												<th>{{ __('Rank') }}</th>
												<th>{{ __('Participant') }}</th>
												<th>{{ __('Trades Completed') }}</th>
												<th>{{ __('Total Profit') }}</th>
												<th>{{ __('Total Loss') }}</th>
												<th>{{ __('Profit Loss Ratio') }}</th>
												<th>{{ __('Efficiency Ratio') }}</th>
												<th>{{ __('Reward') }}</th>
											</tr>
										</thead>
										<tbody>
										@forelse($leaderboard as $k=>$leaderboardVal)
											<tr>
												<td data-label="{{ __('Rank') }}">{{ $leaderboardVal['rank'] }}</td>
												<td data-label="{{ __('Participant') }}">{{ $leaderboardVal['participant'] }}</td>
												<td data-label="{{ __('Trades Completed') }}">{{ $leaderboardVal['trade_completed'] }}</td>
												<td data-label="{{ __('Total Profit') }}">{{ $leaderboardVal['total_profit'] }}</td>
												<td data-label="{{ __('Total Loss') }}">{{ $leaderboardVal['total_loss'] }}</td>
												<td data-label="{{ __('Profit Loss Ratio') }}">{{ $leaderboardVal['profit_loss_ratio'] }}</td>
												<td data-label="{{ __('Efficiency Ratio') }}">{{ $leaderboardVal['efficiency_ratio'] }}</td>
												<td data-label="{{ __('Reward') }}">{{$leaderboardVal['reward'] != '-' ? getCurrencySymbol() : ''}}{{ $leaderboardVal['reward'] }}</td>
											</tr>
										@empty
											<tr>
												<td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
											</tr>
										@endforelse
										</tbody>
									</table>
								</div>
							</div>
						</div>
						<div class="tab-pane fade trading" id="participants" role="tabpanel" aria-labelledby="participants-tab">
							<div class="trade-table scroll-design dark--table">
								<div class="table-container">
									<table>
										<thead>
											<tr>
												<th>{{ __('S.No.') }}</th>
												<th>{{ __('Username') }}</th>
											</tr>
										</thead>
										<tbody>
										@php
											$i = 1;
										@endphp
										@forelse($competition_details->participants as $participant_val)
											<tr>
												<td data-label="{{ __('S.No.') }}">{{ $i }}</td>
												<td data-label="{{ __('Username') }}">{{ $participant_val->user_details->first_name ?? $participant_val->user_details->first_name }} {{ $participant_val->user_details->last_name ?? $participant_val->user_details->last_name }}</td>
											</tr>
											@php
												$i++;
											@endphp
										@empty
											<tr>
												<td class="text-muted text-center" colspan="100%">{{ __('No Data Found')}}</td>
											</tr>
										@endforelse
										</tbody>
									</table>
								</div>
							</div>
						</div>
						<div class="tab-pane fade trading" id="virtual-trade" role="tabpanel" aria-labelledby="virtual-trade-tab">
							@include('user.partials.trade.trade-log')
						</div>
					</div>
				</div>
			</div>

		@if(in_array(\Auth::id(), $competition_details->participants->pluck('user_id')->toArray()))
		@php
			$currentDate = \Carbon\Carbon::now();
			$startDate = \Carbon\Carbon::parse($competition_details->start_time);
			$endDate = \Carbon\Carbon::parse($competition_details->end_time);
		@endphp
		@if($currentDate->between($startDate, $endDate))
		<div class="row">
            <div class="col-lg-12">
                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title">Trades</h4>
                    </div>

                    {{--<div class="table-container">
                        <table id="myTable" class="table">
                            <thead>
                                <tr>
                                    <th scope="col">{{ __('Pair') }}</th>
                                    <th scope="col">{{ __('Price') }}</th>
                                    <th scope="col">{{ __('Market Cap') }}</th>
                                    <th scope="col">{{ __('Daily High') }}</th>
                                    <th scope="col">{{ __('Daily Low') }}</th>
                                    <th scope="col">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($cryptoCurrency as $key => $crypto)
                                <tr>
                                    <td data-label="{{ __('Pair') }}">
                                        <div class="name d-flex align-items-center justify-content-md-start justify-content-end gap-lg-3 gap-2">
                                            <div class="icon">
                                                <img src="{{ $crypto->file }}" class="avatar--sm" alt="{{ __('Crypto-Image') }}">
                                            </div>
                                            <div class="content">
                                                <h6 class="fs-14">{{ $crypto->pair }}</h6>
                                                <span class="fs-13 text--light">{{ $crypto->name }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td data-label="{{ __('Price') }}">
                                        ${{ getArrayValue($crypto->meta, 'current_price') }}
                                    </td>
                                    <td data-label="{{ __('Market Cap') }}">
                                        {{ getArrayValue($crypto->meta, 'market_cap') }}
                                    </td>
                                    <td data-label="{{ __('Daily High') }}">
                                        {{ getArrayValue($crypto->meta, 'high_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Daily Low') }}">
                                        {{ getArrayValue($crypto->meta, 'low_24h') }} %
                                    </td>
                                    <td data-label="{{ __('Action') }}">
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.binary', $crypto->crypto_id) }}" class="i-btn btn--sm btn--primary-outline capsuled">{{ __('Trade') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'practice_trade.value') == \App\Enums\Status::ACTIVE->value)
                                            <a href="{{ route('user.trade.practice', $crypto->crypto_id) }}" class="i-btn btn--sm btn--lite--secondary capsuled">{{ __('Practice') }}</a>
                                        @endif
                                        @if (getArrayValue($setting->system_configuration, 'binary_trade.value') != \App\Enums\Status::ACTIVE->value && getArrayValue($setting->system_configuration, 'practice_trade.value') != \App\Enums\Status::ACTIVE->value)
                                            <span>{{ __('N/A') }}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
					<div class="mt-4">{{ $cryptoCurrency->links() }}</div>--}}
					
					<div class="row g-4">
					@foreach($cryptoCurrency as $key => $crypto)
						<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
							<div class="i-card-sm card-style linear-bg rounded-3">
								<div class="d-flex justify-content-between align-items-center mb-1">
									<h5 class="title text--purple mb-0">{{ $crypto->pair }}</h5>
									<div class="avatar--sm bg--purple">
										<img src="{{ $crypto->file }}" class="avatar--sm" alt="{{ __('Crypto-Image') }}">
									</div>
								</div>

								<div class="card-info text-center">
									<ul class="user-card-list w-100">
										<li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold">{{ __('Price') }}</span>
											<span class="fw-bold text--dark">${{ getArrayValue($crypto->meta, 'current_price') }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold">{{ __('Market Cap') }}</span>
											<span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'market_cap') }}</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3 mb-2"><span class="fw-bold">{{ __('Daily High') }}</span>
											<span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'high_24h') }} %</span>
										</li>
										<li class="d-flex align-items-center justify-content-between gap-3"><span class="fw-bold">{{ __('Daily Low') }}</span>
											<span class="fw-bold text--dark">{{ getArrayValue($crypto->meta, 'low_24h') }} %</span>
										</li>
									</ul>
									{{--<a href="{{ route('user.trade.binary', $crypto->crypto_id) }}" class="i-btn btn--sm btn--primary-outline capsuled">Trade<i class="bi bi-box-arrow-up-right ms-2"></i></a>--}}
									<button class="i-btn btn--sm btn--success capsuled tradeHigh" data-id="{{$crypto->id}}">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::HIGH->value)) }}<i class="bi bi-arrow-up ms-2"></i></button>
									<button class="i-btn btn--sm btn--primary-outline capsuled tradingBtn" data-id="{{$crypto->crypto_id}}">View<i class="bi bi-eye ms-2"></i></button>
									<button class="i-btn btn--sm btn--danger capsuled tradeLow" data-id="{{$crypto->id}}">{{ __(\App\Enums\Trade\TradeVolume::getName(\App\Enums\Trade\TradeVolume::LOW->value)) }}<i class="bi bi-arrow-down ms-2"></i></button>
								</div>
							</div>
						</div>
					@endforeach	
					</div>
					
					
                </div>
            </div>
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-5">
    <div class="i-card-sm mb-4 p-3">
        <div class="i-card-sm blue rounded-3">
            <div class="card-info text-center">
                <h5 class="fw-bold">{{ __('Rank Rewards') }}</h5>
                <ul class="user-card-list w-100 mb-0">
                    @foreach ($rankRewards as $reward)
                        <li class="d-flex align-items-center justify-content-between gap-3">
                            <span class="fw-bold">{{ $reward['from'] }}{{ $reward['from'] != $reward['to'] ? ' to ' . $reward['to'] : '' }}</span>
                            <span class="fw-bold text--dark">{{ getCurrencySymbol() }}{{ number_format($reward['amount'], 2) }} {{ $reward['from'] != $reward['to'] ? 'Shared' : '' }}</span>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
</div>
        </div>
		@endif
		@endif
	</div>
	<form id="tradeSubmitFrm" method="POST" action="" style="display: none">
        @csrf
        <input type="hidden" value="{{ \App\Enums\Trade\TradeType::VIRTUAL_TRADE->value }}" name="type">
        <input type="hidden" value="" name="volume" id="volume">
        <input type="hidden" value="{{ $competition_details->id }}" name="competition_id">
        <div class="input-single">
            <label for="amount">{{ __('Amount') }}</label>
            <input type="text" id="amount" name="amount" value="{{ $competition_details->per_trade_amount }}" placeholder="0.00">
        </div>

        <div class="input-single">
            <label for="parameter">{{ __('Expiry Time') }}</label>
            <select type="text" id="parameter" name="parameter_id" required>
                @foreach($parameters as $key => $parameter)
                    <option value="{{ $parameter->id }}" @if($competition_details->trade_expiry_time == $parameter->id) selected @endif>
                        {{ __('Time') }}: {{$parameter->time.' ' .\App\Enums\Trade\TradeParameterUnit::getName($parameter->unit) }}
                    </option>
                @endforeach
            </select>
        </div>
    </form>
	<div class="modal" id="tradingModal" tabindex="-1" aria-labelledby="tradingModalLabel">
		<div class="modal-dialog modal-dialog-centered" style="width: 100%; max-width: 100%;">
			<div class="modal-content">
				<div class="modal-header primary--light border-0">
					<h5 class="modal-title" id="competitionTitle">Competition Trade</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>				
				<div class="modal-body">
					<div class="tradingview-widget-container p-2 bg-color-2" id="chartContainer" style="width: 100%; height: 500px;">
						<div class="tradingview-widget-container__widget"></div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="i-btn btn--white btn--sm" data-bs-dismiss="modal" aria-label="Close">Close</button>
				</div>
			</div>
		</div>
	</div>
	<div class="modal" id="CompetitionRulesModal" tabindex="-1" aria-labelledby="CompetitionRulesModalLabel">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header primary--light border-0">
					<h5 class="modal-title" id="competitionTitle">Competition Rules</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>				
				<div class="modal-body">
				{!! $competition_details->rules !!}
				</div>
				<div class="modal-footer">
					<button type="button" class="i-btn btn--white btn--sm" data-bs-dismiss="modal" aria-label="Close">Close</button>
				</div>
			</div>
		</div>
	</div>
@endsection

@push('script-push')
<script>
$(document).ready(function() {
	$(document).on("click", ".tradeHigh", function() {
		var crypto_id = $(this).data('id');		
		var volume = "{{ \App\Enums\Trade\TradeVolume::HIGH->value }}";
		
		var routeUrl = "{{ route('user.trade.store', ':id') }}";
		routeUrl = routeUrl.replace(':id', crypto_id);
		$('#tradeSubmitFrm').attr('action', routeUrl);
		$('#volume').val(volume);
		$('#tradeSubmitFrm').submit();
	});	
	$(document).on("click", ".tradeLow", function() {
		var crypto_id = $(this).data('id');		
		var volume = "{{ \App\Enums\Trade\TradeVolume::LOW->value }}";
		
		var routeUrl = "{{ route('user.trade.store', ':id') }}";
		routeUrl = routeUrl.replace(':id', crypto_id);
		$('#tradeSubmitFrm').attr('action', routeUrl);
		$('#volume').val(volume);
		$('#tradeSubmitFrm').submit();
		/*$.ajax({
			headers: {
				"X-CSRF-TOKEN": "{{ csrf_token() }}",
			},
			url: "{{ route('user.trade.trade_details') }}",
			method: "POST",
			data: {
				crypto_id: crypto_id
			},
			success: function(response) {
				if(response.status == 200){
					var cryptoId = response.data.crypto.id;
					var routeUrl = "{{ route('user.trade.store', ':id') }}";
					routeUrl = routeUrl.replace(':id', cryptoId);
					$('#tradeSubmitFrm').attr('action', routeUrl);
					$('#volume').val(volume);
				}else{
					notify('error', response.error);
				}			
			},
			error: function(response) {
				const errorMessage = response.responseJSON ? response.responseJSON.error : "An error occurred.";
				notify('error', errorMessage);
			}
		});*/
	});
	$(document).on("click", ".tradingBtn", function() {
		var crypto_id = $(this).data('id');
		$.ajax({
			headers: {
				"X-CSRF-TOKEN": "{{ csrf_token() }}",
			},
			url: "{{ route('user.trade.trade_details') }}",
			method: "POST",
			data: {
				crypto_id: crypto_id
			},
			success: function(response) {
				//alert(response.data.crypto.symbol);
				if(response.status == 200){
					loadTradingViewChart(response.data.crypto.symbol);
					$('#tradingModal').modal('show');				
				}else{
					notify('error', response.error);
				}			
			},
			error: function(response) {
				const errorMessage = response.responseJSON ? response.responseJSON.error : "An error occurred.";
				notify('error', errorMessage);
			}
		});
	});
	function loadTradingViewChart(symbol) {
		var chartContainer = document.getElementById('chartContainer');
		chartContainer.innerHTML = ''; // Clear previous content if any

		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.async = true;
		script.src = 'https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js';
		script.innerHTML = JSON.stringify({
			"autosize": true,
			"width": "100%",
			"height": 500,
			"symbol": "BITBNS:"+symbol+"{{ strtoupper(getCurrencyName()) }}",
			"interval": "1",
			"timezone": "Asia/Kolkata",
			"theme": "dark",
			"style": "3",
			"locale": "en",
			"enable_publishing": true,
			"hide_legend": true,
			"withdateranges": true,
			"hide_side_toolbar": false,
			"allow_symbol_change": true,
			"details": true,
			"hotlist": true,
			"calendar": false,
			"support_host": "https://www.tradingview.com"
		});
		chartContainer.appendChild(script);
	}
});
$(document).on("click", ".competitionRules", function() {
	$('#CompetitionRulesModal').modal('show');
});
</script>
@endpush
